/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public final class Serializer {
    static final String BASE64_PREFIX = "base64 ";

    private Serializer() {
    }

    public static Map<String, ? extends Serializable> deserializeFromBase64(String rawString) throws IOException {
        HashMap hashMap;
        byte[] decodedBytes = Base64.getDecoder().decode(rawString.getBytes(StandardCharsets.UTF_8));
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(decodedBytes);
        ObjectInputStream in = new ObjectInputStream(bytesIn);
        try {
            hashMap = (HashMap)in.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Could not deserialiaze user profile attributes. Reason: " + e.getMessage());
            }
        }
        in.close();
        return hashMap;
    }

    public static String serializeToBase64(Map<String, Serializable> map) throws IOException {
        HashMap<String, Serializable> serialMap = new HashMap<String, Serializable>(map);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytesOut);
        out.writeObject(serialMap);
        out.close();
        byte[] result = Base64.getEncoder().encode(bytesOut.toByteArray());
        return new String(result);
    }
}

