/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.workflow;

import java.io.Serializable;

public final class Fact
implements Serializable {
    private static final long serialVersionUID = -7459432935402796978L;
    private final String m_key;
    private final Serializable m_obj;

    public Fact(String messageKey, Serializable value) {
        if (messageKey == null || value == null) {
            throw new IllegalArgumentException("Fact message key or value parameters must not be null.");
        }
        this.m_key = messageKey;
        this.m_obj = value;
    }

    public String getMessageKey() {
        return this.m_key;
    }

    public Serializable getValue() {
        return this.m_obj;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Fact)) {
            return false;
        }
        Fact f = (Fact)obj;
        return this.m_key.equals(f.m_key) && this.m_obj.equals(f.m_obj);
    }

    public int hashCode() {
        return this.m_key.hashCode() + 41 * this.m_obj.hashCode();
    }

    public String toString() {
        return "[Fact:" + this.m_obj + "]";
    }
}

