/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.filters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ThreadLocalRandom;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import net.sf.akismet.Akismet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.exceptions.RedirectException;
import org.apache.wiki.api.filters.BasePageFilter;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.ui.EditorManager;
import org.apache.wiki.util.FileUtil;
import org.apache.wiki.util.HttpUtil;
import org.apache.wiki.util.TextUtil;
import org.suigeneris.jrcs.diff.Diff;
import org.suigeneris.jrcs.diff.DiffAlgorithm;
import org.suigeneris.jrcs.diff.DifferentiationFailedException;
import org.suigeneris.jrcs.diff.Revision;
import org.suigeneris.jrcs.diff.delta.AddDelta;
import org.suigeneris.jrcs.diff.delta.ChangeDelta;
import org.suigeneris.jrcs.diff.delta.DeleteDelta;
import org.suigeneris.jrcs.diff.delta.Delta;
import org.suigeneris.jrcs.diff.myers.MyersDiff;

public class SpamFilter
extends BasePageFilter {
    private static final String ATTR_SPAMFILTER_SCORE = "spamfilter.score";
    private static final String REASON_REGEXP = "Regexp";
    private static final String REASON_IP_BANNED_TEMPORARILY = "IPBannedTemporarily";
    private static final String REASON_IP_BANNED_PERMANENTLY = "IPBannedPermanently";
    private static final String REASON_BOT_TRAP = "BotTrap";
    private static final String REASON_AKISMET = "Akismet";
    private static final String REASON_TOO_MANY_URLS = "TooManyUrls";
    private static final String REASON_SIMILAR_MODIFICATIONS = "SimilarModifications";
    private static final String REASON_TOO_MANY_MODIFICATIONS = "TooManyModifications";
    private static final String REASON_PAGENAME_TOO_LONG = "PageNameTooLong";
    private static final String REASON_UTF8_TRAP = "UTF8Trap";
    private static final String LISTVAR = "spamwords";
    private static final String LISTIPVAR = "ips";
    private static final Random RANDOM = ThreadLocalRandom.current();
    public static final String PROP_WORDLIST = "wordlist";
    public static final String PROP_IPLIST = "IPlist";
    public static final String PROP_MAX_PAGENAME_LENGTH = "maxpagenamelength";
    public static final String PROP_ERRORPAGE = "errorpage";
    public static final String PROP_PAGECHANGES = "pagechangesinminute";
    public static final String PROP_SIMILARCHANGES = "similarchanges";
    public static final String PROP_BANTIME = "bantime";
    public static final String PROP_BLACKLIST = "blacklist";
    public static final String PROP_MAXURLS = "maxurls";
    public static final String PROP_AKISMET_API_KEY = "akismet-apikey";
    public static final String PROP_IGNORE_AUTHENTICATED = "ignoreauthenticated";
    public static final String PROP_ALLOWED_GROUPS = "jspwiki.filters.spamfilter.allowedgroups";
    public static final String PROP_CAPTCHA = "captcha";
    public static final String PROP_FILTERSTRATEGY = "strategy";
    public static final String STRATEGY_EAGER = "eager";
    public static final String STRATEGY_SCORE = "score";
    private static final String URL_REGEXP = "(http://|https://|mailto:)([A-Za-z0-9_/\\.\\+\\?\\#\\-\\@=&;]+)";
    private String m_forbiddenWordsPage = "SpamFilterWordList";
    private String m_forbiddenIPsPage = "SpamFilterIPList";
    private String m_pageNameMaxLength = "100";
    private String m_errorPage = "RejectedMessage";
    private String m_blacklist = "SpamFilterWordList/blacklist.txt";
    private final PatternMatcher m_matcher = new Perl5Matcher();
    private final PatternCompiler m_compiler = new Perl5Compiler();
    private Collection<Pattern> m_spamPatterns;
    private Collection<Pattern> m_IPPatterns;
    private Date m_lastRebuild = new Date(0L);
    private static final Logger C_SPAMLOG = LogManager.getLogger((String)"SpamLog");
    private static final Logger LOG = LogManager.getLogger(SpamFilter.class);
    private final Vector<Host> m_temporaryBanList = new Vector();
    private int m_banTime = 60;
    private final Vector<Host> m_lastModifications = new Vector();
    private int m_limitSinglePageChanges = 5;
    private int m_limitSimilarChanges = 2;
    private int m_maxUrls = 10;
    private Pattern m_urlPattern;
    private Akismet m_akismet;
    private String m_akismetAPIKey;
    private boolean m_useCaptcha;
    private final int m_scoreLimit = 1;
    private boolean m_ignoreAuthenticated;
    private String[] m_allowedGroups;
    private boolean m_stopAtFirstMatch = true;
    private static String c_hashName;
    private static long c_lastUpdate;
    private static final long HASH_DELAY = 24L;
    private static final int REJECT = 0;
    private static final int ACCEPT = 1;
    private static final int NOTE = 2;

    public void initialize(Engine engine, Properties properties) {
        this.m_forbiddenWordsPage = properties.getProperty(PROP_WORDLIST, this.m_forbiddenWordsPage);
        this.m_forbiddenIPsPage = properties.getProperty(PROP_IPLIST, this.m_forbiddenIPsPage);
        this.m_pageNameMaxLength = properties.getProperty(PROP_MAX_PAGENAME_LENGTH, this.m_pageNameMaxLength);
        this.m_errorPage = properties.getProperty(PROP_ERRORPAGE, this.m_errorPage);
        this.m_limitSinglePageChanges = TextUtil.getIntegerProperty((Properties)properties, (String)PROP_PAGECHANGES, (int)this.m_limitSinglePageChanges);
        this.m_limitSimilarChanges = TextUtil.getIntegerProperty((Properties)properties, (String)PROP_SIMILARCHANGES, (int)this.m_limitSimilarChanges);
        this.m_maxUrls = TextUtil.getIntegerProperty((Properties)properties, (String)PROP_MAXURLS, (int)this.m_maxUrls);
        this.m_banTime = TextUtil.getIntegerProperty((Properties)properties, (String)PROP_BANTIME, (int)this.m_banTime);
        this.m_blacklist = properties.getProperty(PROP_BLACKLIST, this.m_blacklist);
        this.m_ignoreAuthenticated = TextUtil.getBooleanProperty((Properties)properties, (String)PROP_IGNORE_AUTHENTICATED, (boolean)this.m_ignoreAuthenticated);
        this.m_allowedGroups = StringUtils.split((String)StringUtils.defaultString((String)properties.getProperty(PROP_ALLOWED_GROUPS, this.m_blacklist)), (char)',');
        this.m_useCaptcha = properties.getProperty(PROP_CAPTCHA, "").equals("asirra");
        try {
            this.m_urlPattern = this.m_compiler.compile(URL_REGEXP);
        }
        catch (MalformedPatternException e) {
            LOG.fatal("Internal error: Someone put in a faulty pattern.", (Throwable)e);
            throw new InternalWikiException("Faulty pattern.", e);
        }
        this.m_akismetAPIKey = TextUtil.getStringProperty((Properties)properties, (String)PROP_AKISMET_API_KEY, (String)this.m_akismetAPIKey);
        this.m_stopAtFirstMatch = TextUtil.getStringProperty((Properties)properties, (String)PROP_FILTERSTRATEGY, (String)STRATEGY_EAGER).equals(STRATEGY_EAGER);
        LOG.info("# Spam filter initialized.  Temporary ban time " + this.m_banTime + " mins, max page changes/minute: " + this.m_limitSinglePageChanges);
    }

    private static String log(Context ctx, int type, String source, String message) {
        String reason;
        message = TextUtil.replaceString((String)message, (String)"\r\n", (String)"\\r\\n");
        message = TextUtil.replaceString((String)message, (String)"\"", (String)"\\\"");
        String uid = SpamFilter.getUniqueID();
        String page = ctx.getPage().getName();
        String addr = ctx.getHttpRequest() != null ? HttpUtil.getRemoteAddress((HttpServletRequest)ctx.getHttpRequest()) : "-";
        switch (type) {
            case 0: {
                reason = "REJECTED";
                break;
            }
            case 1: {
                reason = "ACCEPTED";
                break;
            }
            case 2: {
                reason = "NOTE";
                break;
            }
            default: {
                throw new InternalWikiException("Illegal type " + type);
            }
        }
        C_SPAMLOG.info(reason + " " + source + " " + uid + " " + addr + " \"" + page + "\" " + message);
        return uid;
    }

    public String preSave(Context context, String content) throws RedirectException {
        Integer score;
        this.cleanBanList();
        this.refreshBlacklists(context);
        Change change = SpamFilter.getChange(context, content);
        if (!this.ignoreThisUser(context)) {
            this.checkBanList(context, change);
            this.checkSinglePageChange(context, change);
            this.checkIPList(context);
            this.checkPatternList(context, change);
            this.checkPageName(context);
        }
        if (!this.m_stopAtFirstMatch && (score = (Integer)context.getVariable(ATTR_SPAMFILTER_SCORE)) != null && score >= 1) {
            throw new RedirectException("Herb says you got too many points", this.getRedirectPage(context));
        }
        SpamFilter.log(context, 1, "-", change.toString());
        return content;
    }

    private void checkPageName(Context context) throws RedirectException {
        Page page = context.getPage();
        String pageName = page.getName();
        int maxlength = Integer.parseInt(this.m_pageNameMaxLength);
        if (pageName.length() > maxlength) {
            String uid = SpamFilter.log(context, 0, "PageNameTooLong(" + this.m_pageNameMaxLength + ")", pageName);
            LOG.info("SPAM:PageNameTooLong (" + uid + "). The length of the page name is too large (" + pageName.length() + " , limit is " + this.m_pageNameMaxLength + ")");
            this.checkStrategy(context, "Herb says '" + pageName + "' is a bad pageName and I trust Herb! (Incident code " + uid + ")");
        }
    }

    private void checkStrategy(Context context, String message) throws RedirectException {
        if (this.m_stopAtFirstMatch) {
            throw new RedirectException(message, this.getRedirectPage(context));
        }
        Integer score = (Integer)context.getVariable(ATTR_SPAMFILTER_SCORE);
        score = score != null ? Integer.valueOf(score + 1) : Integer.valueOf(1);
        context.setVariable(ATTR_SPAMFILTER_SCORE, (Object)score);
    }

    private Collection<Pattern> parseWordList(Page source, String list) {
        ArrayList<Pattern> compiledpatterns = new ArrayList<Pattern>();
        if (list != null) {
            StringTokenizer tok = new StringTokenizer(list, " \t\n");
            while (tok.hasMoreTokens()) {
                String pattern = tok.nextToken();
                try {
                    compiledpatterns.add(this.m_compiler.compile(pattern));
                }
                catch (MalformedPatternException e) {
                    LOG.debug("Malformed spam filter pattern " + pattern);
                    source.setAttribute("error", (Object)("Malformed spam filter pattern " + pattern));
                }
            }
        }
        return compiledpatterns;
    }

    private Collection<Pattern> parseBlacklist(String list) {
        ArrayList<Pattern> compiledpatterns = new ArrayList<Pattern>();
        if (list != null) {
            try {
                String line;
                BufferedReader in = new BufferedReader(new StringReader(list));
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    int ws = line.indexOf(32);
                    if (ws == -1) {
                        ws = line.indexOf(9);
                    }
                    if (ws != -1) {
                        line = line.substring(0, ws);
                    }
                    try {
                        compiledpatterns.add(this.m_compiler.compile(line));
                    }
                    catch (MalformedPatternException e) {
                        LOG.debug("Malformed spam filter pattern " + line);
                    }
                }
            }
            catch (IOException e) {
                LOG.info("Could not read patterns; returning what I got", (Throwable)e);
            }
        }
        return compiledpatterns;
    }

    private synchronized void checkSinglePageChange(Context context, Change change) throws RedirectException {
        HttpServletRequest req = context.getHttpRequest();
        if (req != null) {
            String uid;
            Host host;
            String addr = HttpUtil.getRemoteAddress((HttpServletRequest)req);
            int hostCounter = 0;
            int changeCounter = 0;
            LOG.debug("Change is " + change.m_change);
            long time = System.currentTimeMillis() - 60000L;
            Iterator<Host> i = this.m_lastModifications.iterator();
            while (i.hasNext()) {
                Host host2 = i.next();
                if (host2.getAddedTime() < time) {
                    LOG.debug("Removed host " + host2.getAddress() + " from modification queue (expired)");
                    i.remove();
                    continue;
                }
                if (host2.getAddress().equals(addr)) {
                    ++hostCounter;
                }
                if (host2.getChange() == null || !host2.getChange().equals(change)) continue;
                ++changeCounter;
            }
            if (hostCounter >= this.m_limitSinglePageChanges) {
                host = new Host(addr, null);
                this.m_temporaryBanList.add(host);
                uid = SpamFilter.log(context, 0, REASON_TOO_MANY_MODIFICATIONS, change.m_change);
                LOG.info("SPAM:TooManyModifications (" + uid + "). Added host " + addr + " to temporary ban list for doing too many modifications/minute");
                this.checkStrategy(context, "Herb says you look like a spammer, and I trust Herb! (Incident code " + uid + ")");
            }
            if (changeCounter >= this.m_limitSimilarChanges) {
                host = new Host(addr, null);
                this.m_temporaryBanList.add(host);
                uid = SpamFilter.log(context, 0, REASON_SIMILAR_MODIFICATIONS, change.m_change);
                LOG.info("SPAM:SimilarModifications (" + uid + "). Added host " + addr + " to temporary ban list for doing too many similar modifications");
                this.checkStrategy(context, "Herb says you look like a spammer, and I trust Herb! (Incident code " + uid + ")");
            }
            String tstChange = change.toString();
            int urlCounter = 0;
            while (this.m_matcher.contains(tstChange, this.m_urlPattern)) {
                MatchResult m = this.m_matcher.getMatch();
                tstChange = tstChange.substring(m.endOffset(0));
                ++urlCounter;
            }
            if (urlCounter > this.m_maxUrls) {
                Host host3 = new Host(addr, null);
                this.m_temporaryBanList.add(host3);
                String uid2 = SpamFilter.log(context, 0, REASON_TOO_MANY_URLS, change.toString());
                LOG.info("SPAM:TooManyUrls (" + uid2 + "). Added host " + addr + " to temporary ban list for adding too many URLs");
                this.checkStrategy(context, "Herb says you look like a spammer, and I trust Herb! (Incident code " + uid2 + ")");
            }
            this.checkBotTrap(context, change);
            this.checkUTF8(context, change);
            this.checkAkismet(context, change);
            this.m_lastModifications.add(new Host(addr, change));
        }
    }

    private void checkAkismet(Context context, Change change) throws RedirectException {
        if (this.m_akismetAPIKey != null) {
            if (this.m_akismet == null) {
                LOG.info("Initializing Akismet spam protection.");
                this.m_akismet = new Akismet(this.m_akismetAPIKey, context.getEngine().getBaseURL());
                if (!this.m_akismet.verifyAPIKey()) {
                    LOG.error("Akismet API key cannot be verified.  Please check your config.");
                    this.m_akismetAPIKey = null;
                    this.m_akismet = null;
                }
            }
            HttpServletRequest req = context.getHttpRequest();
            if (change.m_adds == 0 && change.m_removals > 0) {
                return;
            }
            if (req != null && this.m_akismet != null) {
                LOG.debug("Calling Akismet to check for spam...");
                StopWatch sw = new StopWatch();
                sw.start();
                String ipAddress = HttpUtil.getRemoteAddress((HttpServletRequest)req);
                String userAgent = req.getHeader("User-Agent");
                String referrer = req.getHeader("Referer");
                String permalink = context.getViewURL(context.getPage().getName());
                String commentType = context.getRequestContext().equals(ContextEnum.PAGE_COMMENT.getRequestContext()) ? "comment" : "edit";
                String commentAuthor = context.getCurrentUser().getName();
                String commentAuthorEmail = null;
                String commentAuthorURL = null;
                boolean isSpam = this.m_akismet.commentCheck(ipAddress, userAgent, referrer, permalink, commentType, commentAuthor, commentAuthorEmail, commentAuthorURL, change.toString(), null);
                sw.stop();
                LOG.debug("Akismet request done in: " + sw);
                if (isSpam) {
                    String uid = SpamFilter.log(context, 0, REASON_AKISMET, change.toString());
                    LOG.info("SPAM:Akismet (" + uid + "). Akismet thinks this change is spam; added host to temporary ban list.");
                    this.checkStrategy(context, "Akismet tells Herb you're a spammer, Herb trusts Akismet, and I trust Herb! (Incident code " + uid + ")");
                }
            }
        }
    }

    public static String getBotFieldName() {
        return "submit_auth";
    }

    private void checkBotTrap(Context context, Change change) throws RedirectException {
        String unspam;
        HttpServletRequest request = context.getHttpRequest();
        if (request != null && (unspam = request.getParameter(SpamFilter.getBotFieldName())) != null && !unspam.isEmpty()) {
            String uid = SpamFilter.log(context, 0, REASON_BOT_TRAP, change.toString());
            LOG.info("SPAM:BotTrap (" + uid + ").  Wildly behaving bot detected.");
            this.checkStrategy(context, "Spamming attempt detected. (Incident code " + uid + ")");
        }
    }

    private void checkUTF8(Context context, Change change) throws RedirectException {
        String utf8field;
        HttpServletRequest request = context.getHttpRequest();
        if (request != null && (utf8field = request.getParameter("encodingcheck")) != null && !utf8field.equals("\u3041")) {
            String uid = SpamFilter.log(context, 0, REASON_UTF8_TRAP, change.toString());
            LOG.info("SPAM:UTF8Trap (" + uid + ").  Wildly posting dumb bot detected.");
            this.checkStrategy(context, "Spamming attempt detected. (Incident code " + uid + ")");
        }
    }

    private synchronized void cleanBanList() {
        long now = System.currentTimeMillis();
        Iterator<Host> i = this.m_temporaryBanList.iterator();
        while (i.hasNext()) {
            Host host = i.next();
            if (host.getReleaseTime() >= now) continue;
            LOG.debug("Removed host " + host.getAddress() + " from temporary ban list (expired)");
            i.remove();
        }
    }

    private void checkBanList(Context context, Change change) throws RedirectException {
        HttpServletRequest req = context.getHttpRequest();
        if (req != null) {
            String remote = HttpUtil.getRemoteAddress((HttpServletRequest)req);
            long now = System.currentTimeMillis();
            for (Host host : this.m_temporaryBanList) {
                if (!host.getAddress().equals(remote)) continue;
                long timeleft = (host.getReleaseTime() - now) / 1000L;
                SpamFilter.log(context, 0, REASON_IP_BANNED_TEMPORARILY, change.m_change);
                this.checkStrategy(context, "You have been temporarily banned from modifying this wiki. (" + timeleft + " seconds of ban left)");
            }
        }
    }

    private void refreshBlacklists(Context context) {
        try {
            Page sourceIPs;
            Attachment att;
            boolean rebuild = false;
            Page sourceSpam = ((PageManager)context.getEngine().getManager(PageManager.class)).getPage(this.m_forbiddenWordsPage);
            if (sourceSpam != null && (this.m_spamPatterns == null || this.m_spamPatterns.isEmpty() || sourceSpam.getLastModified().after(this.m_lastRebuild))) {
                rebuild = true;
            }
            if ((att = ((AttachmentManager)context.getEngine().getManager(AttachmentManager.class)).getAttachmentInfo(context, this.m_blacklist)) != null && (this.m_spamPatterns == null || this.m_spamPatterns.isEmpty() || att.getLastModified().after(this.m_lastRebuild))) {
                rebuild = true;
            }
            if ((sourceIPs = ((PageManager)context.getEngine().getManager(PageManager.class)).getPage(this.m_forbiddenIPsPage)) != null && (this.m_IPPatterns == null || this.m_IPPatterns.isEmpty() || sourceIPs.getLastModified().after(this.m_lastRebuild))) {
                rebuild = true;
            }
            if (rebuild) {
                this.m_lastRebuild = new Date();
                this.m_spamPatterns = this.parseWordList(sourceSpam, sourceSpam != null ? (String)sourceSpam.getAttribute(LISTVAR) : null);
                LOG.info("Spam filter reloaded - recognizing " + this.m_spamPatterns.size() + " patterns from page " + this.m_forbiddenWordsPage);
                this.m_IPPatterns = this.parseWordList(sourceIPs, sourceIPs != null ? (String)sourceIPs.getAttribute(LISTIPVAR) : null);
                LOG.info("IP filter reloaded - recognizing " + this.m_IPPatterns.size() + " patterns from page " + this.m_forbiddenIPsPage);
                if (att != null) {
                    InputStream in = ((AttachmentManager)context.getEngine().getManager(AttachmentManager.class)).getAttachmentStream(att);
                    StringWriter out = new StringWriter();
                    FileUtil.copyContents((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), (Writer)out);
                    Collection<Pattern> blackList = this.parseBlacklist(out.toString());
                    LOG.info("...recognizing additional " + blackList.size() + " patterns from blacklist " + this.m_blacklist);
                    this.m_spamPatterns.addAll(blackList);
                }
            }
        }
        catch (IOException ex) {
            LOG.info("Unable to read attachment data, continuing...", (Throwable)ex);
        }
        catch (ProviderException ex) {
            LOG.info("Failed to read spam filter attachment, continuing...", (Throwable)ex);
        }
    }

    private void checkPatternList(Context context, Change change) throws RedirectException {
        if (this.m_spamPatterns == null || context.getPage().getName().equals(this.m_forbiddenWordsPage)) {
            return;
        }
        Object ch = change.toString();
        if (context.getHttpRequest() != null) {
            ch = (String)ch + HttpUtil.getRemoteAddress((HttpServletRequest)context.getHttpRequest());
        }
        for (Pattern p : this.m_spamPatterns) {
            if (!this.m_matcher.contains((String)ch, p)) continue;
            String uid = SpamFilter.log(context, 0, "Regexp(" + p.getPattern() + ")", (String)ch);
            LOG.info("SPAM:Regexp (" + uid + "). Content matches the spam filter '" + p.getPattern() + "'");
            this.checkStrategy(context, "Herb says '" + p.getPattern() + "' is a bad spam word and I trust Herb! (Incident code " + uid + ")");
        }
    }

    private void checkIPList(Context context) throws RedirectException {
        if (this.m_IPPatterns == null || context.getPage().getName().equals(this.m_forbiddenIPsPage)) {
            return;
        }
        String remoteIP = HttpUtil.getRemoteAddress((HttpServletRequest)context.getHttpRequest());
        LOG.info("Attempting to match remoteIP " + remoteIP + " against " + this.m_IPPatterns.size() + " patterns");
        for (Pattern p : this.m_IPPatterns) {
            LOG.debug("Attempting to match remoteIP with " + p.getPattern());
            if (!this.m_matcher.contains(remoteIP, p)) continue;
            String uid = SpamFilter.log(context, 0, "IPBannedPermanently(" + p.getPattern() + ")", remoteIP);
            LOG.info("SPAM:IPBanList (" + uid + "). remoteIP matches the IP filter '" + p.getPattern() + "'");
            this.checkStrategy(context, "Herb says '" + p.getPattern() + "' is a banned IP and I trust Herb! (Incident code " + uid + ")");
        }
    }

    private void checkPatternList(Context context, String change) throws RedirectException {
        Change c = new Change();
        c.m_change = change;
        this.checkPatternList(context, c);
    }

    private static Change getChange(Context context, String newText) {
        Page page = context.getPage();
        StringBuffer change = new StringBuffer();
        Engine engine = context.getEngine();
        Change ch = new Change();
        try {
            String oldText = ((PageManager)engine.getManager(PageManager.class)).getPureText(page.getName(), -1);
            Object[] first = Diff.stringToArray((String)oldText);
            Object[] second = Diff.stringToArray((String)newText);
            Revision rev = Diff.diff((Object[])first, (Object[])second, (DiffAlgorithm)new MyersDiff());
            if (rev == null || rev.size() == 0) {
                return ch;
            }
            for (int i = 0; i < rev.size(); ++i) {
                Delta d = rev.getDelta(i);
                if (d instanceof AddDelta) {
                    d.getRevised().toString(change, "", "\r\n");
                    ++ch.m_adds;
                    continue;
                }
                if (d instanceof ChangeDelta) {
                    d.getRevised().toString(change, "", "\r\n");
                    ++ch.m_adds;
                    continue;
                }
                if (!(d instanceof DeleteDelta)) continue;
                ++ch.m_removals;
            }
        }
        catch (DifferentiationFailedException e) {
            LOG.error("Diff failed", (Throwable)e);
        }
        String changeNote = (String)page.getAttribute("changenote");
        if (changeNote != null) {
            change.append("\r\n");
            change.append(changeNote);
        }
        if (page.getAuthor() != null) {
            change.append("\r\n").append(page.getAuthor());
        }
        ch.m_change = change.toString();
        return ch;
    }

    private boolean ignoreThisUser(Context context) {
        if (context.hasAdminPermissions()) {
            return true;
        }
        List<String> groups = Arrays.asList(this.m_allowedGroups);
        if (Arrays.stream(context.getWikiSession().getRoles()).anyMatch(role -> groups.contains(role.getName()))) {
            return true;
        }
        if (this.m_ignoreAuthenticated && context.getWikiSession().isAuthenticated()) {
            return true;
        }
        return context.getVariable(PROP_CAPTCHA) != null;
    }

    private static String getUniqueID() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            char x = (char)(65 + RANDOM.nextInt(26));
            sb.append(x);
        }
        return sb.toString();
    }

    private String getRedirectPage(Context ctx) {
        if (this.m_useCaptcha) {
            return ctx.getURL(ContextEnum.PAGE_NONE.getRequestContext(), "Captcha.jsp", "page= " + ctx.getEngine().encodeName(ctx.getPage().getName()));
        }
        return ctx.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), this.m_errorPage);
    }

    public boolean isValidUserProfile(Context context, UserProfile profile) {
        try {
            this.checkPatternList(context, profile.getEmail());
            this.checkPatternList(context, profile.getFullname());
            this.checkPatternList(context, profile.getLoginName());
        }
        catch (RedirectException e) {
            LOG.info("Detected attempt to create a spammer user account (see above for rejection reason)");
            return false;
        }
        return true;
    }

    public static String getSpamHash(Page page, HttpServletRequest request) {
        long lastModified = 0L;
        if (page.getLastModified() != null) {
            lastModified = page.getLastModified().getTime();
        }
        long remote = HttpUtil.getRemoteAddress((HttpServletRequest)request).hashCode();
        return Long.toString(lastModified ^ remote);
    }

    public static String getHashFieldName(HttpServletRequest request) {
        String hash = null;
        if (request.getSession() != null && (hash = (String)request.getSession().getAttribute("_hash")) == null) {
            hash = c_hashName;
            request.getSession().setAttribute("_hash", (Object)hash);
        }
        if (c_hashName == null || c_lastUpdate < System.currentTimeMillis() - 86400000L) {
            c_hashName = SpamFilter.getUniqueID().toLowerCase();
            c_lastUpdate = System.currentTimeMillis();
        }
        return hash != null ? hash : c_hashName;
    }

    public static boolean checkHash(Context context, PageContext pageContext) throws IOException {
        String hashName = SpamFilter.getHashFieldName((HttpServletRequest)pageContext.getRequest());
        if (pageContext.getRequest().getParameter(hashName) == null && pageContext.getAttribute(hashName) == null) {
            Change change = SpamFilter.getChange(context, EditorManager.getEditedText(pageContext));
            SpamFilter.log(context, 0, "MissingHash", change.m_change);
            String redirect = context.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), "SessionExpired");
            ((HttpServletResponse)pageContext.getResponse()).sendRedirect(redirect);
            return false;
        }
        return true;
    }

    public static String insertInputFields(PageContext pageContext) {
        Context ctx = Context.findContext((PageContext)pageContext);
        Engine engine = ctx.getEngine();
        StringBuilder sb = new StringBuilder();
        if (engine.getContentEncoding().equals(StandardCharsets.UTF_8)) {
            sb.append("<input name='encodingcheck' type='hidden' value='\u3041' />\n");
        }
        return sb.toString();
    }

    private static class Change {
        public String m_change;
        public int m_adds;
        public int m_removals;

        private Change() {
        }

        public String toString() {
            return this.m_change;
        }

        public boolean equals(Object o) {
            if (o instanceof Change) {
                return this.m_change.equals(((Change)o).m_change);
            }
            return false;
        }

        public int hashCode() {
            return this.m_change.hashCode() + 17;
        }
    }

    private class Host {
        private final long m_addedTime = System.currentTimeMillis();
        private final long m_releaseTime;
        private final String m_address;
        private final Change m_change;

        public String getAddress() {
            return this.m_address;
        }

        public long getReleaseTime() {
            return this.m_releaseTime;
        }

        public long getAddedTime() {
            return this.m_addedTime;
        }

        public Change getChange() {
            return this.m_change;
        }

        public Host(String ipaddress, Change change) {
            this.m_address = ipaddress;
            this.m_change = change;
            this.m_releaseTime = System.currentTimeMillis() + (long)(SpamFilter.this.m_banTime * 60) * 1000L;
        }
    }
}

