/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider;

import com.vladsch.flexmark.util.html.MutableAttributes;
import java.util.List;
import org.apache.oro.text.regex.Pattern;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider.ImageLinkAttributeProviderState;
import org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider.NodeAttributeProviderState;
import org.apache.wiki.markdown.nodes.JSPWikiLink;
import org.apache.wiki.parser.LinkParsingOperations;

public class ExternalLinkAttributeProviderState
implements NodeAttributeProviderState<JSPWikiLink> {
    private final boolean hasRef;
    private final boolean m_useRelNofollow;
    private final Context wikiContext;
    private final LinkParsingOperations linkOperations;
    private final boolean isImageInlining;
    private final List<Pattern> inlineImagePatterns;

    public ExternalLinkAttributeProviderState(Context wikiContext, boolean hasRef, boolean isImageInlining, List<Pattern> inlineImagePatterns) {
        this.hasRef = hasRef;
        this.wikiContext = wikiContext;
        this.linkOperations = new LinkParsingOperations(wikiContext);
        this.isImageInlining = isImageInlining;
        this.inlineImagePatterns = inlineImagePatterns;
        this.m_useRelNofollow = wikiContext.getBooleanWikiProperty("jspwiki.translatorReader.useRelNofollow", false);
    }

    @Override
    public void setAttributes(MutableAttributes attributes, JSPWikiLink link) {
        if (this.linkOperations.isImageLink(link.getUrl().toString(), this.isImageInlining, this.inlineImagePatterns)) {
            new ImageLinkAttributeProviderState(this.wikiContext, link.getText().toString(), this.hasRef).setAttributes(attributes, link);
        } else {
            attributes.replaceValue((CharSequence)"class", (CharSequence)"external");
            attributes.replaceValue((CharSequence)"href", (CharSequence)link.getUrl().toString());
        }
        if (this.m_useRelNofollow) {
            attributes.replaceValue((CharSequence)"rel", (CharSequence)"nofollow");
        }
    }
}

