/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kendra.model.SourceDocument;
import java.util.List;

@SdkInternalApi
public class SourceDocumentMarshaller {
    private static final MarshallingInfo<String> DOCUMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentId").build();
    private static final MarshallingInfo<List> SUGGESTIONATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SuggestionAttributes").build();
    private static final MarshallingInfo<List> ADDITIONALATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalAttributes").build();
    private static final SourceDocumentMarshaller instance = new SourceDocumentMarshaller();

    public static SourceDocumentMarshaller getInstance() {
        return instance;
    }

    public void marshall(SourceDocument sourceDocument, ProtocolMarshaller protocolMarshaller) {
        if (sourceDocument == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sourceDocument.getDocumentId(), DOCUMENTID_BINDING);
            protocolMarshaller.marshall(sourceDocument.getSuggestionAttributes(), SUGGESTIONATTRIBUTES_BINDING);
            protocolMarshaller.marshall(sourceDocument.getAdditionalAttributes(), ADDITIONALATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

