/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.SourceDocument;
import com.amazonaws.services.kendra.model.SuggestionValue;
import com.amazonaws.services.kendra.model.transform.SuggestionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Suggestion
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private SuggestionValue value;
    private List<SourceDocument> sourceDocuments;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Suggestion withId(String id) {
        this.setId(id);
        return this;
    }

    public void setValue(SuggestionValue value) {
        this.value = value;
    }

    public SuggestionValue getValue() {
        return this.value;
    }

    public Suggestion withValue(SuggestionValue value) {
        this.setValue(value);
        return this;
    }

    public List<SourceDocument> getSourceDocuments() {
        return this.sourceDocuments;
    }

    public void setSourceDocuments(Collection<SourceDocument> sourceDocuments) {
        if (sourceDocuments == null) {
            this.sourceDocuments = null;
            return;
        }
        this.sourceDocuments = new ArrayList<SourceDocument>(sourceDocuments);
    }

    public Suggestion withSourceDocuments(SourceDocument ... sourceDocuments) {
        if (this.sourceDocuments == null) {
            this.setSourceDocuments(new ArrayList<SourceDocument>(sourceDocuments.length));
        }
        for (SourceDocument ele : sourceDocuments) {
            this.sourceDocuments.add(ele);
        }
        return this;
    }

    public Suggestion withSourceDocuments(Collection<SourceDocument> sourceDocuments) {
        this.setSourceDocuments(sourceDocuments);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue()).append(",");
        }
        if (this.getSourceDocuments() != null) {
            sb.append("SourceDocuments: ").append(this.getSourceDocuments());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Suggestion)) {
            return false;
        }
        Suggestion other = (Suggestion)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getSourceDocuments() == null ^ this.getSourceDocuments() == null) {
            return false;
        }
        return other.getSourceDocuments() == null || other.getSourceDocuments().equals(this.getSourceDocuments());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getSourceDocuments() == null ? 0 : this.getSourceDocuments().hashCode());
        return hashCode;
    }

    public Suggestion clone() {
        try {
            return (Suggestion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SuggestionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

