/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.xmlrpc;

import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import org.apache.wiki.LinkCollector;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.xmlrpc.AbstractRPCHandler;
import org.apache.xmlrpc.XmlRpcException;

public class RPCHandlerUTF8
extends AbstractRPCHandler {
    public String getApplicationName() {
        this.checkPermission(PagePermission.VIEW);
        return this.m_engine.getApplicationName();
    }

    public Vector<String> getAllPages() {
        this.checkPermission(PagePermission.VIEW);
        Set<Page> pages = ((PageManager)this.m_engine.getManager(PageManager.class)).getRecentChanges();
        return pages.stream().filter(p -> !(p instanceof Attachment)).map(Page::getName).collect(Collectors.toCollection(Vector::new));
    }

    @Override
    protected Hashtable<String, Object> encodeWikiPage(Page page) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("name", page.getName());
        Date d = page.getLastModified();
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(14, -(cal.get(15) + (cal.getTimeZone().inDaylightTime(d) ? cal.get(16) : 0)));
        ht.put("lastModified", cal.getTime());
        ht.put("version", page.getVersion());
        if (page.getAuthor() != null) {
            ht.put("author", page.getAuthor());
        }
        return ht;
    }

    @Override
    public Vector<Hashtable<String, Object>> getRecentChanges(Date since) {
        this.checkPermission(PagePermission.VIEW);
        Set<Page> pages = ((PageManager)this.m_engine.getManager(PageManager.class)).getRecentChanges();
        Vector<Hashtable<String, Object>> result = new Vector<Hashtable<String, Object>>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(since);
        cal.add(14, cal.get(15) + (cal.getTimeZone().inDaylightTime(since) ? cal.get(16) : 0));
        since = cal.getTime();
        for (Page page : pages) {
            if (!page.getLastModified().after(since) || page instanceof Attachment) continue;
            result.add(this.encodeWikiPage(page));
        }
        return result;
    }

    private String parsePageCheckCondition(String pagename) throws XmlRpcException {
        if (!((PageManager)this.m_engine.getManager(PageManager.class)).wikiPageExists(pagename)) {
            throw new XmlRpcException(1, "No such page '" + pagename + "' found, o master.");
        }
        Page p = ((PageManager)this.m_engine.getManager(PageManager.class)).getPage(pagename);
        this.checkPermission(PermissionFactory.getPagePermission(p, "view"));
        return pagename;
    }

    public Hashtable<String, Object> getPageInfo(String pagename) throws XmlRpcException {
        return this.encodeWikiPage(((PageManager)this.m_engine.getManager(PageManager.class)).getPage(this.parsePageCheckCondition(pagename)));
    }

    public Hashtable<String, Object> getPageInfoVersion(String pagename, int version) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.encodeWikiPage(((PageManager)this.m_engine.getManager(PageManager.class)).getPage(pagename, version));
    }

    public String getPage(String pagename) throws XmlRpcException {
        return ((PageManager)this.m_engine.getManager(PageManager.class)).getPureText(this.parsePageCheckCondition(pagename), -1);
    }

    public String getPageVersion(String pagename, int version) throws XmlRpcException {
        return ((PageManager)this.m_engine.getManager(PageManager.class)).getPureText(this.parsePageCheckCondition(pagename), version);
    }

    public String getPageHTML(String pagename) throws XmlRpcException {
        return ((RenderingManager)this.m_engine.getManager(RenderingManager.class)).getHTML(this.parsePageCheckCondition(pagename));
    }

    public String getPageHTMLVersion(String pagename, int version) throws XmlRpcException {
        return ((RenderingManager)this.m_engine.getManager(RenderingManager.class)).getHTML(this.parsePageCheckCondition(pagename), version);
    }

    public Vector<Hashtable<String, String>> listLinks(String pagename) throws XmlRpcException {
        Hashtable<String, String> ht;
        pagename = this.parsePageCheckCondition(pagename);
        Page page = ((PageManager)this.m_engine.getManager(PageManager.class)).getPage(pagename);
        String pagedata = ((PageManager)this.m_engine.getManager(PageManager.class)).getPureText(page);
        LinkCollector localCollector = new LinkCollector();
        LinkCollector extCollector = new LinkCollector();
        LinkCollector attCollector = new LinkCollector();
        Context context = Wiki.context().create(this.m_engine, page);
        ((RenderingManager)this.m_engine.getManager(RenderingManager.class)).textToHTML(context, pagedata, localCollector, extCollector, attCollector);
        Vector<Hashtable<String, String>> result = new Vector<Hashtable<String, String>>();
        for (String link : localCollector.getLinks()) {
            ht = new Hashtable<String, String>();
            ht.put("page", link);
            ht.put("type", "local");
            if (((PageManager)this.m_engine.getManager(PageManager.class)).wikiPageExists(link)) {
                ht.put("href", context.getViewURL(link));
            } else {
                ht.put("href", context.getURL(ContextEnum.PAGE_EDIT.getRequestContext(), link));
            }
            result.add(ht);
        }
        for (String link : attCollector.getLinks()) {
            ht = new Hashtable();
            ht.put("page", link);
            ht.put("type", "local");
            ht.put("href", context.getURL(ContextEnum.PAGE_ATTACH.getRequestContext(), link));
            result.add(ht);
        }
        for (String link : extCollector.getLinks()) {
            ht = new Hashtable();
            ht.put("page", link);
            ht.put("type", "external");
            ht.put("href", link);
            result.add(ht);
        }
        return result;
    }
}

