/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.search.QueryItem;
import org.apache.wiki.search.SearchResult;

public class SearchMatcher {
    private final org.apache.wiki.api.search.QueryItem[] m_queries;
    private final Engine m_engine;

    public SearchMatcher(Engine engine, org.apache.wiki.api.search.QueryItem[] queries) {
        this.m_engine = engine;
        this.m_queries = queries != null ? (org.apache.wiki.api.search.QueryItem[])queries.clone() : null;
    }

    @Deprecated
    public SearchMatcher(WikiEngine engine, QueryItem[] queries) {
        this((Engine)engine, (org.apache.wiki.api.search.QueryItem[])queries);
    }

    public SearchResult matchPageContent(String wikiname, String pageText) throws IOException {
        String line;
        if (this.m_queries == null) {
            return null;
        }
        int[] scores = new int[this.m_queries.length];
        BufferedReader in = new BufferedReader(new StringReader(pageText));
        while ((line = in.readLine()) != null) {
            line = line.toLowerCase();
            for (int j = 0; j < this.m_queries.length; ++j) {
                int index = -1;
                while ((index = line.indexOf(this.m_queries[j].word, index + 1)) != -1) {
                    if (this.m_queries[j].type != -1) {
                        int n = j;
                        scores[n] = scores[n] + 1;
                        continue;
                    }
                    return null;
                }
            }
        }
        int totalscore = 0;
        for (int j = 0; j < scores.length; ++j) {
            if (wikiname.toLowerCase().contains(this.m_queries[j].word) && this.m_queries[j].type != -1) {
                int n = j;
                scores[n] = scores[n] + 5;
            }
            if (this.m_queries[j].type == 1 && scores[j] == 0) {
                return null;
            }
            totalscore += scores[j];
        }
        if (totalscore > 0) {
            return new SearchResultImpl(wikiname, totalscore);
        }
        return null;
    }

    public class SearchResultImpl
    implements SearchResult {
        final int m_score;
        final Page m_page;

        public SearchResultImpl(String name, int score) {
            this.m_page = Wiki.contents().page(SearchMatcher.this.m_engine, name);
            this.m_score = score;
        }

        @Override
        public WikiPage getPage() {
            return (WikiPage)this.m_page;
        }

        public int getScore() {
            return this.m_score;
        }

        public String[] getContexts() {
            return new String[0];
        }
    }
}

