/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.pages;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Page;

public class PageTimeComparator
implements Comparator<Page>,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = LogManager.getLogger(PageTimeComparator.class);

    @Override
    public int compare(Page p1, Page p2) {
        if (p1 == null || p2 == null) {
            LOG.error("W1 or W2 is NULL in PageTimeComparator!");
            return 0;
        }
        Date w1LastMod = p1.getLastModified();
        Date w2LastMod = p2.getLastModified();
        if (w1LastMod == null) {
            LOG.error("NULL MODIFY DATE WITH " + p1.getName());
            return 0;
        }
        if (w2LastMod == null) {
            LOG.error("NULL MODIFY DATE WITH " + p2.getName());
            return 0;
        }
        int timecomparison = w2LastMod.compareTo(w1LastMod);
        if (timecomparison == 0) {
            return p1.compareTo((Object)p2);
        }
        return timecomparison;
    }
}

