/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.modules;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.wiki.api.Release;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.modules.ModuleManager;
import org.apache.wiki.modules.WikiModuleInfo;

public abstract class BaseModuleManager
implements ModuleManager {
    protected final Engine m_engine;

    public BaseModuleManager(Engine engine) {
        this.m_engine = engine;
    }

    @Override
    public boolean checkCompatibility(WikiModuleInfo info) {
        String minVersion = info.getMinVersion();
        String maxVersion = info.getMaxVersion();
        return Release.isNewerOrEqual((String)minVersion) && Release.isOlderOrEqual((String)maxVersion);
    }

    protected <T extends WikiModuleInfo> Collection<WikiModuleInfo> modules(Iterator<T> iterator) {
        TreeSet<WikiModuleInfo> ls = new TreeSet<WikiModuleInfo>();
        while (iterator.hasNext()) {
            WikiModuleInfo wmi = (WikiModuleInfo)iterator.next();
            ls.add(wmi);
        }
        return ls;
    }
}

