/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dlp.eventsourcing.commands;

import java.util.List;
import org.apache.james.dlp.eventsourcing.aggregates.DLPAggregateId;
import org.apache.james.dlp.eventsourcing.aggregates.DLPDomainConfiguration;
import org.apache.james.dlp.eventsourcing.commands.StoreCommand;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.CommandHandler;
import org.apache.james.eventsourcing.EventWithState;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class StoreCommandHandler
implements CommandHandler<StoreCommand> {
    private final EventStore eventStore;

    public StoreCommandHandler(EventStore eventStore) {
        this.eventStore = eventStore;
    }

    public Class<StoreCommand> handledClass() {
        return StoreCommand.class;
    }

    public Publisher<List<EventWithState>> handle(StoreCommand storeCommand) {
        DLPAggregateId aggregateId = new DLPAggregateId(storeCommand.getDomain());
        return Mono.from((Publisher)this.eventStore.getEventsOfAggregate((AggregateId)aggregateId)).map(history -> DLPDomainConfiguration.load(aggregateId, history).store(storeCommand.getRules()));
    }
}

