/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import jakarta.json.bind.adapter.JsonbAdapter;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.bind.serializer.JsonbSerializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.RuntimeTypeHolder;
import org.eclipse.yasson.internal.components.AbstractComponentBinding;
import org.eclipse.yasson.internal.components.AdapterBinding;
import org.eclipse.yasson.internal.components.ComponentBindings;
import org.eclipse.yasson.internal.components.DeserializerBinding;
import org.eclipse.yasson.internal.components.SerializerBinding;
import org.eclipse.yasson.internal.model.customization.ComponentBoundCustomization;

public class ComponentMatcher {
    private final JsonbContext jsonbContext;
    private volatile boolean genericComponents;
    private final ConcurrentMap<Type, ComponentBindings> userComponents;

    ComponentMatcher(JsonbContext context) {
        Objects.requireNonNull(context);
        this.jsonbContext = context;
        this.userComponents = new ConcurrentHashMap<Type, ComponentBindings>();
        this.init();
    }

    void init() {
        JsonbAdapter[] adapters;
        JsonbDeserializer[] deserializers;
        JsonbSerializer[] serializers;
        for (JsonbSerializer serializer : serializers = (JsonbSerializer[])this.jsonbContext.getConfig().getProperty("jsonb.serializers").orElseGet(() -> new JsonbSerializer[0])) {
            SerializerBinding serializerBinding = this.introspectSerializerBinding(serializer.getClass(), serializer);
            this.addSerializer(serializerBinding.getBindingType(), serializerBinding);
        }
        for (JsonbDeserializer deserializer : deserializers = (JsonbDeserializer[])this.jsonbContext.getConfig().getProperty("jsonb.derializers").orElseGet(() -> new JsonbDeserializer[0])) {
            DeserializerBinding deserializerBinding = this.introspectDeserializerBinding(deserializer.getClass(), deserializer);
            this.addDeserializer(deserializerBinding.getBindingType(), deserializerBinding);
        }
        for (JsonbAdapter adapter : adapters = (JsonbAdapter[])this.jsonbContext.getConfig().getProperty("jsonb.adapters").orElseGet(() -> new JsonbAdapter[0])) {
            AdapterBinding adapterBinding = this.introspectAdapterBinding(adapter.getClass(), adapter);
            this.addAdapter(adapterBinding.getBindingType(), adapterBinding);
        }
    }

    private ComponentBindings getBindingInfo(Type type) {
        return this.userComponents.compute(type, (type1, bindingInfo) -> bindingInfo != null ? bindingInfo : new ComponentBindings((Type)type1));
    }

    private void addSerializer(Type bindingType, SerializerBinding serializer) {
        this.userComponents.computeIfPresent(bindingType, (type, bindings) -> {
            if (bindings.getSerializer() != null) {
                return bindings;
            }
            this.registerGeneric(bindingType);
            return new ComponentBindings(bindingType, serializer, bindings.getDeserializer(), bindings.getAdapterInfo());
        });
    }

    private void addDeserializer(Type bindingType, DeserializerBinding deserializer) {
        this.userComponents.computeIfPresent(bindingType, (type, bindings) -> {
            if (bindings.getDeserializer() != null) {
                return bindings;
            }
            this.registerGeneric(bindingType);
            return new ComponentBindings(bindingType, bindings.getSerializer(), deserializer, bindings.getAdapterInfo());
        });
    }

    private void addAdapter(Type bindingType, AdapterBinding adapter) {
        this.userComponents.computeIfPresent(bindingType, (type, bindings) -> {
            if (bindings.getAdapterInfo() != null) {
                return bindings;
            }
            this.registerGeneric(bindingType);
            return new ComponentBindings(bindingType, bindings.getSerializer(), bindings.getDeserializer(), adapter);
        });
    }

    private void registerGeneric(Type bindingType) {
        if (bindingType instanceof ParameterizedType && !this.genericComponents) {
            this.genericComponents = true;
        }
    }

    public Optional<SerializerBinding<?>> getSerializerBinding(Type propertyRuntimeType, ComponentBoundCustomization customization) {
        if (customization == null || customization.getSerializerBinding() == null) {
            return this.searchComponentBinding(propertyRuntimeType, ComponentBindings::getSerializer);
        }
        return Optional.of(customization.getSerializerBinding());
    }

    public Optional<DeserializerBinding<?>> getDeserializerBinding(Type propertyRuntimeType, ComponentBoundCustomization customization) {
        if (customization == null || customization.getDeserializerBinding() == null) {
            return this.searchComponentBinding(propertyRuntimeType, ComponentBindings::getDeserializer);
        }
        return Optional.of(customization.getDeserializerBinding());
    }

    public Optional<AdapterBinding> getSerializeAdapterBinding(Type propertyRuntimeType, ComponentBoundCustomization customization) {
        if (customization == null || customization.getSerializeAdapterBinding() == null) {
            return this.searchComponentBinding(propertyRuntimeType, ComponentBindings::getAdapterInfo);
        }
        return Optional.of(customization.getSerializeAdapterBinding());
    }

    public Optional<AdapterBinding> getDeserializeAdapterBinding(Type propertyRuntimeType, ComponentBoundCustomization customization) {
        if (customization == null || customization.getDeserializeAdapterBinding() == null) {
            return this.searchComponentBinding(propertyRuntimeType, ComponentBindings::getAdapterInfo);
        }
        return Optional.of(customization.getDeserializeAdapterBinding());
    }

    private <T extends AbstractComponentBinding> Optional<T> searchComponentBinding(Type runtimeType, Function<ComponentBindings, T> supplier) {
        Optional<T> match;
        ComponentBindings binding = (ComponentBindings)this.userComponents.get(runtimeType);
        if (binding != null && (match = this.getMatchingBinding(runtimeType, binding, supplier)).isPresent()) {
            return match;
        }
        Optional<Class<?>> runtimeClass = ReflectionUtils.getOptionalRawType(runtimeType);
        if (runtimeClass.isPresent()) {
            Optional<T> superBinding;
            for (Class<?> ifc : runtimeClass.get().getInterfaces()) {
                Optional<T> match2;
                ComponentBindings ifcBinding = (ComponentBindings)this.userComponents.get(ifc);
                if (ifcBinding == null || !(match2 = this.getMatchingBinding(ifc, ifcBinding, supplier)).isPresent()) continue;
                return match2;
            }
            Class<?> superClass = runtimeClass.get().getSuperclass();
            if (superClass != null && superClass != Object.class && (superBinding = this.searchComponentBinding(superClass, supplier)).isPresent()) {
                return superBinding;
            }
        }
        return Optional.empty();
    }

    private <T> Optional<T> getMatchingBinding(Type runtimeType, ComponentBindings binding, Function<ComponentBindings, T> supplier) {
        T component = supplier.apply(binding);
        if (component != null && this.matches(runtimeType, binding.getBindingType())) {
            return Optional.of(component);
        }
        return Optional.empty();
    }

    private boolean matches(Type runtimeType, Type componentBindingType) {
        if (componentBindingType.equals(runtimeType)) {
            return true;
        }
        if (componentBindingType instanceof Class && runtimeType instanceof Class) {
            return ((Class)componentBindingType).isAssignableFrom((Class)runtimeType);
        }
        if (!this.genericComponents) {
            return false;
        }
        return runtimeType instanceof ParameterizedType && componentBindingType instanceof ParameterizedType && ReflectionUtils.getRawType(componentBindingType).isAssignableFrom(ReflectionUtils.getRawType(runtimeType)) && this.matchTypeArguments((ParameterizedType)runtimeType, (ParameterizedType)componentBindingType);
    }

    private boolean matchTypeArguments(ParameterizedType requiredType, ParameterizedType componentBound) {
        Type[] adapterBoundTypeArguments;
        Type[] requiredTypeArguments = requiredType.getActualTypeArguments();
        if (requiredTypeArguments.length != (adapterBoundTypeArguments = componentBound.getActualTypeArguments()).length) {
            return false;
        }
        for (int i = 0; i < requiredTypeArguments.length; ++i) {
            Type adapterTypeArgument = adapterBoundTypeArguments[i];
            if (requiredTypeArguments[i].equals(adapterTypeArgument)) continue;
            return false;
        }
        return true;
    }

    AdapterBinding introspectAdapterBinding(Class<? extends JsonbAdapter> adapterClass, JsonbAdapter instance) {
        ParameterizedType adapterRuntimeType = ReflectionUtils.findParameterizedType(adapterClass, JsonbAdapter.class);
        Type[] adapterTypeArguments = adapterRuntimeType.getActualTypeArguments();
        Type adaptFromType = this.resolveTypeArg(adapterTypeArguments[0], adapterClass);
        Type adaptToType = this.resolveTypeArg(adapterTypeArguments[1], adapterClass);
        ComponentBindings componentBindings = this.getBindingInfo(adaptFromType);
        if (componentBindings.getAdapterInfo() != null && componentBindings.getAdapterInfo().getAdapter().getClass().equals(adapterClass)) {
            return componentBindings.getAdapterInfo();
        }
        JsonbAdapter newAdapter = instance != null ? instance : this.jsonbContext.getComponentInstanceCreator().getOrCreateComponent(adapterClass);
        return new AdapterBinding(adaptFromType, adaptToType, newAdapter);
    }

    DeserializerBinding introspectDeserializerBinding(Class<? extends JsonbDeserializer> deserializerClass, JsonbDeserializer instance) {
        ParameterizedType deserializerRuntimeType = ReflectionUtils.findParameterizedType(deserializerClass, JsonbDeserializer.class);
        Type deserializerBindingType = this.resolveTypeArg(deserializerRuntimeType.getActualTypeArguments()[0], deserializerClass);
        ComponentBindings componentBindings = this.getBindingInfo(deserializerBindingType);
        if (componentBindings.getDeserializer() != null && componentBindings.getDeserializer().getClass().equals(deserializerClass)) {
            return componentBindings.getDeserializer();
        }
        JsonbDeserializer deserializer = instance != null ? instance : this.jsonbContext.getComponentInstanceCreator().getOrCreateComponent(deserializerClass);
        return new DeserializerBinding(deserializerBindingType, deserializer);
    }

    SerializerBinding introspectSerializerBinding(Class<? extends JsonbSerializer> serializerClass, JsonbSerializer instance) {
        ParameterizedType serializerRuntimeType = ReflectionUtils.findParameterizedType(serializerClass, JsonbSerializer.class);
        Type serBindingType = this.resolveTypeArg(serializerRuntimeType.getActualTypeArguments()[0], serializerClass.getClass());
        ComponentBindings componentBindings = this.getBindingInfo(serBindingType);
        if (componentBindings.getSerializer() != null && componentBindings.getSerializer().getClass().equals(serializerClass)) {
            return componentBindings.getSerializer();
        }
        JsonbSerializer serializer = instance != null ? instance : this.jsonbContext.getComponentInstanceCreator().getOrCreateComponent(serializerClass);
        return new SerializerBinding(serBindingType, serializer);
    }

    private Type resolveTypeArg(Type adapterTypeArg, Type adapterType) {
        if (adapterTypeArg instanceof ParameterizedType) {
            return ReflectionUtils.resolveTypeArguments((ParameterizedType)adapterTypeArg, adapterType);
        }
        if (adapterTypeArg instanceof TypeVariable) {
            return ReflectionUtils.resolveItemVariableType(new RuntimeTypeHolder(null, adapterType), (TypeVariable)adapterTypeArg, true);
        }
        return adapterTypeArg;
    }
}

