/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import jakarta.inject.Singleton;
import java.io.FileNotFoundException;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.blob.export.api.BlobExportMechanism;
import org.apache.james.blob.export.file.LocalFileBlobExportMechanism;
import org.apache.james.modules.BlobExportImplChoice;
import org.apache.james.modules.LocalFileBlobExportMechanismModule;
import org.apache.james.modules.mailbox.ConfigurationComponent;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobExportMechanismModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlobExportMechanismModule.class);

    protected void configure() {
        this.install((Module)new LocalFileBlobExportMechanismModule());
    }

    @Provides
    @Singleton
    @VisibleForTesting
    BlobExportImplChoice provideChoice(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfigurations(ConfigurationComponent.NAMES);
            return BlobExportImplChoice.from(configuration).orElseGet(() -> {
                LOGGER.warn("No blob export mechanism defined. Defaulting to " + BlobExportImplChoice.LOCAL_FILE.getImplName());
                return BlobExportImplChoice.LOCAL_FILE;
            });
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find blob configuration file, using localFile blob exporting as the default");
            return BlobExportImplChoice.LOCAL_FILE;
        }
    }

    @Provides
    @Singleton
    @VisibleForTesting
    BlobExportMechanism provideMechanism(BlobExportImplChoice implChoice, Provider<LocalFileBlobExportMechanism> localFileMechanismProvider) {
        switch (implChoice) {
            case LOCAL_FILE: {
                return (BlobExportMechanism)localFileMechanismProvider.get();
            }
        }
        throw new RuntimeException("blobExportMechanism '" + implChoice.getImplName() + "' is not supported yet");
    }
}

