/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail.dao;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.postgres.PostgresMessageId;
import org.apache.james.mailbox.postgres.mail.dao.PostgresThreadDataDefinition;
import org.jooq.Record;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresThreadDAO {
    private final PostgresExecutor postgresExecutor;

    public PostgresThreadDAO(PostgresExecutor postgresExecutor) {
        this.postgresExecutor = postgresExecutor;
    }

    public Mono<Void> insertSome(Username username, Set<Integer> hashMimeMessageIds, PostgresMessageId messageId, ThreadId threadId, Optional<Integer> hashBaseSubject) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.batch((Collection)hashMimeMessageIds.stream().map(hashMimeMessageId -> dslContext.insertInto(PostgresThreadDataDefinition.PostgresThreadTable.TABLE_NAME).set(PostgresThreadDataDefinition.PostgresThreadTable.USERNAME, (Object)username.asString()).set(PostgresThreadDataDefinition.PostgresThreadTable.HASH_MIME_MESSAGE_ID, hashMimeMessageId).set(PostgresThreadDataDefinition.PostgresThreadTable.MESSAGE_ID, (Object)messageId.asUuid()).set(PostgresThreadDataDefinition.PostgresThreadTable.THREAD_ID, (Object)((PostgresMessageId)threadId.getBaseMessageId()).asUuid()).set(PostgresThreadDataDefinition.PostgresThreadTable.HASH_BASE_SUBJECT, (Object)hashBaseSubject.orElse(null))).collect(ImmutableList.toImmutableList()))));
    }

    public Flux<Pair<Optional<Integer>, ThreadId>> findThreads(Username username, Set<Integer> hashMimeMessageIds) {
        if (hashMimeMessageIds.isEmpty()) {
            return Flux.empty();
        }
        Function<Collection, Flux> function = hashMimeMessageIdSubSet -> this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresThreadDataDefinition.PostgresThreadTable.THREAD_ID, PostgresThreadDataDefinition.PostgresThreadTable.HASH_BASE_SUBJECT).from(PostgresThreadDataDefinition.PostgresThreadTable.TABLE_NAME).where(PostgresThreadDataDefinition.PostgresThreadTable.USERNAME.eq((Object)username.asString())).and(PostgresThreadDataDefinition.PostgresThreadTable.HASH_MIME_MESSAGE_ID.in(hashMimeMessageIdSubSet)))).map(this::readRecord);
        if (hashMimeMessageIds.size() <= 32) {
            return function.apply(hashMimeMessageIds);
        }
        return Flux.fromIterable((Iterable)Iterables.partition(hashMimeMessageIds, (int)32)).flatMap(function);
    }

    public Flux<MessageId> findMessageIds(ThreadId threadId, Username username) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.selectDistinct(PostgresThreadDataDefinition.PostgresThreadTable.MESSAGE_ID).from(PostgresThreadDataDefinition.PostgresThreadTable.TABLE_NAME).where(PostgresThreadDataDefinition.PostgresThreadTable.USERNAME.eq((Object)username.asString())).and(PostgresThreadDataDefinition.PostgresThreadTable.THREAD_ID.eq((Object)((PostgresMessageId)PostgresMessageId.class.cast(threadId.getBaseMessageId())).asUuid())).orderBy(PostgresThreadDataDefinition.PostgresThreadTable.MESSAGE_ID))).map(record -> PostgresMessageId.Factory.of((UUID)record.get(PostgresThreadDataDefinition.PostgresThreadTable.MESSAGE_ID)));
    }

    public Pair<Optional<Integer>, ThreadId> readRecord(Record record) {
        return Pair.of(Optional.ofNullable((Integer)record.get(PostgresThreadDataDefinition.PostgresThreadTable.HASH_BASE_SUBJECT)), (Object)ThreadId.fromBaseMessageId((MessageId)PostgresMessageId.Factory.of((UUID)record.get(PostgresThreadDataDefinition.PostgresThreadTable.THREAD_ID))));
    }

    public Mono<Void> deleteSome(Username username, PostgresMessageId messageId) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresThreadDataDefinition.PostgresThreadTable.TABLE_NAME).where(PostgresThreadDataDefinition.PostgresThreadTable.USERNAME.eq((Object)username.asString())).and(PostgresThreadDataDefinition.PostgresThreadTable.MESSAGE_ID.eq((Object)messageId.asUuid()))));
    }

    public static class Factory {
        private final PostgresExecutor.Factory executorFactory;

        @Inject
        @Singleton
        public Factory(PostgresExecutor.Factory executorFactory) {
            this.executorFactory = executorFactory;
        }

        public PostgresThreadDAO create(Optional<Domain> domain) {
            return new PostgresThreadDAO(this.executorFactory.create(domain));
        }
    }
}

