/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.james.core.quota.QuotaComponent;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.quota.task.RecomputeCurrentQuotasService;
import org.apache.james.mailbox.quota.task.RecomputeCurrentQuotasTask;
import org.apache.james.mailbox.quota.task.RecomputeSingleQuotaComponentResult;
import org.apache.james.mailbox.quota.task.RunningOptionsDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;

public class RecomputeCurrentQuotasTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final String type;
    private final Optional<Long> processedQuotaRoots;
    private final Optional<ImmutableList<String>> failedQuotaRoots;
    private final Optional<List<RecomputeSingleQuotaComponentResultDTO>> recomputeSingleQuotaComponentResults;
    private final Optional<RunningOptionsDTO> runningOptions;
    private final Instant timestamp;

    private static RecomputeCurrentQuotasTaskAdditionalInformationDTO fromDomainObject(RecomputeCurrentQuotasTask.Details details, String type) {
        Optional<RecomputeSingleQuotaComponentResult> recomputeSingleQuotaComponentResultOfMailbox = details.getResults().stream().filter(recomputeSingleQuotaComponentResult -> QuotaComponent.MAILBOX.getValue().equals(recomputeSingleQuotaComponentResult.getQuotaComponent())).findFirst();
        return new RecomputeCurrentQuotasTaskAdditionalInformationDTO(type, recomputeSingleQuotaComponentResultOfMailbox.map(RecomputeSingleQuotaComponentResult::getProcessedIdentifierCount).or(() -> Optional.of(0L)), recomputeSingleQuotaComponentResultOfMailbox.map(RecomputeSingleQuotaComponentResult::getFailedIdentifiers).or(() -> Optional.of(ImmutableList.of())), Optional.of(details.getResults().stream().map(recomputeSingleQuotaComponentResult -> new RecomputeSingleQuotaComponentResultDTO(recomputeSingleQuotaComponentResult.getQuotaComponent(), recomputeSingleQuotaComponentResult.getProcessedIdentifierCount(), recomputeSingleQuotaComponentResult.getFailedIdentifiers())).collect(Collectors.toUnmodifiableList())), Optional.of(RunningOptionsDTO.asDTO(details.getRunningOptions())), details.timestamp());
    }

    public static AdditionalInformationDTOModule<RecomputeCurrentQuotasTask.Details, RecomputeCurrentQuotasTaskAdditionalInformationDTO> module() {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(RecomputeCurrentQuotasTask.Details.class).convertToDTO(RecomputeCurrentQuotasTaskAdditionalInformationDTO.class).toDomainObjectConverter(RecomputeCurrentQuotasTaskAdditionalInformationDTO::toDomainObject).toDTOConverter(RecomputeCurrentQuotasTaskAdditionalInformationDTO::fromDomainObject).typeName(RecomputeCurrentQuotasTask.RECOMPUTE_CURRENT_QUOTAS.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    public RecomputeCurrentQuotasTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="processedQuotaRoots") Optional<Long> processedQuotaRoots, @JsonProperty(value="failedQuotaRoots") Optional<ImmutableList<String>> failedQuotaRoots, @JsonProperty(value="recomputeSingleQuotaComponentResults") Optional<List<RecomputeSingleQuotaComponentResultDTO>> recomputeSingleQuotaComponentResults, @JsonProperty(value="runningOptions") Optional<RunningOptionsDTO> runningOptions, @JsonProperty(value="timestamp") Instant timestamp) {
        this.type = type;
        this.processedQuotaRoots = processedQuotaRoots;
        this.failedQuotaRoots = failedQuotaRoots;
        this.recomputeSingleQuotaComponentResults = recomputeSingleQuotaComponentResults;
        this.runningOptions = runningOptions;
        this.timestamp = timestamp;
    }

    public Optional<Long> getProcessedQuotaRoots() {
        return this.processedQuotaRoots;
    }

    public Optional<ImmutableList<String>> getFailedQuotaRoots() {
        return this.failedQuotaRoots;
    }

    public Optional<List<RecomputeSingleQuotaComponentResultDTO>> getRecomputeSingleQuotaComponentResults() {
        return this.recomputeSingleQuotaComponentResults;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        return this.type;
    }

    public Optional<RunningOptionsDTO> getRunningOptions() {
        return this.runningOptions;
    }

    private RecomputeCurrentQuotasTask.Details toDomainObject() {
        return new RecomputeCurrentQuotasTask.Details(this.timestamp, this.recomputeSingleQuotaComponentResults.map(recomputeSingleQuotaComponentResults -> recomputeSingleQuotaComponentResults.stream().map(recomputeSingleQuotaComponentResultDTO -> new RecomputeSingleQuotaComponentResult(recomputeSingleQuotaComponentResultDTO.getQuotaComponent(), recomputeSingleQuotaComponentResultDTO.getProcessedIdentifierCount(), recomputeSingleQuotaComponentResultDTO.getFailedIdentifiers())).collect(Collectors.toUnmodifiableList())).orElse((List)ImmutableList.of((Object)new RecomputeSingleQuotaComponentResult(QuotaComponent.MAILBOX.getValue(), this.processedQuotaRoots.get(), this.failedQuotaRoots.get()))), this.runningOptions.map(RunningOptionsDTO::asDomainObject).orElse(RecomputeCurrentQuotasService.RunningOptions.DEFAULT));
    }

    static class RecomputeSingleQuotaComponentResultDTO {
        private final String quotaComponent;
        private final long processedIdentifierCount;
        private final ImmutableList<String> failedIdentifiers;

        public RecomputeSingleQuotaComponentResultDTO(@JsonProperty(value="quotaComponent") String quotaComponent, @JsonProperty(value="processedQuotaRoots") long processedIdentifierCount, @JsonProperty(value="failedQuotaRoots") ImmutableList<String> failedIdentifiers) {
            this.quotaComponent = quotaComponent;
            this.processedIdentifierCount = processedIdentifierCount;
            this.failedIdentifiers = failedIdentifiers;
        }

        public String getQuotaComponent() {
            return this.quotaComponent;
        }

        public long getProcessedIdentifierCount() {
            return this.processedIdentifierCount;
        }

        public ImmutableList<String> getFailedIdentifiers() {
            return this.failedIdentifiers;
        }

        public final boolean equals(Object o) {
            if (o instanceof RecomputeSingleQuotaComponentResultDTO) {
                RecomputeSingleQuotaComponentResultDTO that = (RecomputeSingleQuotaComponentResultDTO)o;
                return Objects.equals(this.quotaComponent, that.quotaComponent) && Objects.equals(this.processedIdentifierCount, that.processedIdentifierCount) && Objects.equals(this.failedIdentifiers, that.failedIdentifiers);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.quotaComponent, this.processedIdentifierCount, this.failedIdentifiers);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("quotaComponent", (Object)this.quotaComponent).add("processedIdentifierCount", this.processedIdentifierCount).add("failedIdentifiers", this.failedIdentifiers).toString();
        }
    }
}

