/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.rabbitmq;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class RabbitMQServerVersion {
    private final Version version;

    public static RabbitMQServerVersion of(String input) {
        return new RabbitMQServerVersion(VersionUtil.parseVersion((String)input, (String)"rabbitmq", (String)"version"));
    }

    @VisibleForTesting
    RabbitMQServerVersion(Version version) {
        Preconditions.checkNotNull((Object)version, (Object)"version cannot be null");
        this.version = version;
    }

    public boolean isAtLeast(RabbitMQServerVersion other) {
        return this.version.compareTo(other.version) >= 0;
    }

    public String asString() {
        return this.version.toFullString();
    }

    public final boolean equals(Object other) {
        if (other instanceof RabbitMQServerVersion) {
            RabbitMQServerVersion that = (RabbitMQServerVersion)other;
            return Objects.equals(this.version.getMajorVersion(), that.version.getMajorVersion()) && Objects.equals(this.version.getMinorVersion(), that.version.getMinorVersion()) && Objects.equals(this.version.getPatchLevel(), that.version.getPatchLevel());
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.version);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", (Object)this.version).toString();
    }
}

