/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.condition.user;

import jakarta.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.webadmin.UserCondition;
import org.apache.james.webadmin.service.UserMailboxesService;

public class HasNoMailboxesCondition
implements UserCondition {
    public static final String HAS_NO_MAILBOXES_PARAM = "hasNoMailboxes";
    private final UserMailboxesService userMailboxesService;

    @Inject
    public HasNoMailboxesCondition(UserMailboxesService userMailboxesService) {
        this.userMailboxesService = userMailboxesService;
    }

    public boolean test(Username username) {
        try {
            return this.userMailboxesService.listMailboxes(username, UserMailboxesService.Options.Force).isEmpty();
        }
        catch (UsersRepositoryException e) {
            throw new RuntimeException(e);
        }
    }
}

