/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.SparseFixedBitSet;

public class BitSetIterator
extends DocIdSetIterator {
    private final BitSet bits;
    private final int length;
    private final long cost;
    private int doc = -1;

    private static <T extends BitSet> T getBitSet(DocIdSetIterator iterator, Class<? extends T> clazz) {
        if (iterator instanceof BitSetIterator) {
            BitSet bits = ((BitSetIterator)iterator).bits;
            assert (bits != null);
            if (clazz.isInstance(bits)) {
                return (T)((BitSet)clazz.cast(bits));
            }
        }
        return null;
    }

    public static FixedBitSet getFixedBitSetOrNull(DocIdSetIterator iterator) {
        return BitSetIterator.getBitSet(iterator, FixedBitSet.class);
    }

    public static SparseFixedBitSet getSparseFixedBitSetOrNull(DocIdSetIterator iterator) {
        return BitSetIterator.getBitSet(iterator, SparseFixedBitSet.class);
    }

    public BitSetIterator(BitSet bits, long cost) {
        if (cost < 0L) {
            throw new IllegalArgumentException("cost must be >= 0, got " + cost);
        }
        this.bits = bits;
        this.length = bits.length();
        this.cost = cost;
    }

    public BitSet getBitSet() {
        return this.bits;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    public void setDocId(int docId) {
        this.doc = docId;
    }

    @Override
    public int nextDoc() {
        return this.advance(this.doc + 1);
    }

    @Override
    public int advance(int target) {
        if (target >= this.length) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        this.doc = this.bits.nextSetBit(target);
        return this.doc;
    }

    @Override
    public long cost() {
        return this.cost;
    }

    @Override
    public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
        BitSet bitSet2;
        if (upTo > this.doc && (bitSet2 = this.bits) instanceof FixedBitSet) {
            FixedBitSet fixedBits = (FixedBitSet)bitSet2;
            int actualUpto = Math.min(upTo, this.length);
            actualUpto = (int)Math.min((long)actualUpto, (long)offset + (long)bitSet.length());
            FixedBitSet.orRange(fixedBits, this.doc, bitSet, this.doc - offset, actualUpto - this.doc);
            this.advance(actualUpto);
        }
        super.intoBitSet(upTo, bitSet, offset);
    }
}

