/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Intervals;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsQuery;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsQueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class IntervalsFuzzy
implements IntervalsQueryVariant,
IntervalsVariant,
JsonpSerializable {
    @Nullable
    private final String analyzer;
    @Nullable
    private final String fuzziness;
    @Nullable
    private final Integer prefixLength;
    private final String term;
    @Nullable
    private final Boolean transpositions;
    @Nullable
    private final String useField;
    public static final JsonpDeserializer<IntervalsFuzzy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IntervalsFuzzy::setupIntervalsFuzzyDeserializer);

    private IntervalsFuzzy(Builder builder) {
        this.analyzer = builder.analyzer;
        this.fuzziness = builder.fuzziness;
        this.prefixLength = builder.prefixLength;
        this.term = ApiTypeHelper.requireNonNull(builder.term, this, "term");
        this.transpositions = builder.transpositions;
        this.useField = builder.useField;
    }

    public static IntervalsFuzzy of(Function<Builder, ObjectBuilder<IntervalsFuzzy>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public IntervalsQuery.Kind _intervalsQueryKind() {
        return IntervalsQuery.Kind.Fuzzy;
    }

    @Override
    public Intervals.Kind _intervalsKind() {
        return Intervals.Kind.Fuzzy;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public final String fuzziness() {
        return this.fuzziness;
    }

    @Nullable
    public final Integer prefixLength() {
        return this.prefixLength;
    }

    public final String term() {
        return this.term;
    }

    @Nullable
    public final Boolean transpositions() {
        return this.transpositions;
    }

    @Nullable
    public final String useField() {
        return this.useField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.fuzziness != null) {
            generator.writeKey("fuzziness");
            generator.write(this.fuzziness);
        }
        if (this.prefixLength != null) {
            generator.writeKey("prefix_length");
            generator.write(this.prefixLength.intValue());
        }
        generator.writeKey("term");
        generator.write(this.term);
        if (this.transpositions != null) {
            generator.writeKey("transpositions");
            generator.write(this.transpositions.booleanValue());
        }
        if (this.useField != null) {
            generator.writeKey("use_field");
            generator.write(this.useField);
        }
    }

    public Builder toBuilder() {
        return new Builder().analyzer(this.analyzer).fuzziness(this.fuzziness).prefixLength(this.prefixLength).term(this.term).transpositions(this.transpositions).useField(this.useField);
    }

    protected static void setupIntervalsFuzzyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::fuzziness, JsonpDeserializer.stringDeserializer(), "fuzziness");
        op.add(Builder::prefixLength, JsonpDeserializer.integerDeserializer(), "prefix_length");
        op.add(Builder::term, JsonpDeserializer.stringDeserializer(), "term");
        op.add(Builder::transpositions, JsonpDeserializer.booleanDeserializer(), "transpositions");
        op.add(Builder::useField, JsonpDeserializer.stringDeserializer(), "use_field");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IntervalsFuzzy> {
        @Nullable
        private String analyzer;
        @Nullable
        private String fuzziness;
        @Nullable
        private Integer prefixLength;
        private String term;
        @Nullable
        private Boolean transpositions;
        @Nullable
        private String useField;

        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public final Builder fuzziness(@Nullable String value) {
            this.fuzziness = value;
            return this;
        }

        public final Builder prefixLength(@Nullable Integer value) {
            this.prefixLength = value;
            return this;
        }

        public final Builder term(String value) {
            this.term = value;
            return this;
        }

        public final Builder transpositions(@Nullable Boolean value) {
            this.transpositions = value;
            return this;
        }

        public final Builder useField(@Nullable String value) {
            this.useField = value;
            return this;
        }

        @Override
        public IntervalsFuzzy build() {
            this._checkSingleUse();
            return new IntervalsFuzzy(this);
        }
    }
}

