/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.Optional;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.netty.ConnectionLimitUpstreamHandler;
import org.apache.james.protocols.netty.ConnectionPerIpLimitUpstreamHandler;
import org.apache.james.protocols.netty.TimeoutHandler;

@ChannelHandler.Sharable
public abstract class AbstractChannelPipelineFactory<C extends SocketChannel>
extends ChannelInitializer<C> {
    public static final int MAX_LINE_LENGTH = 8192;
    private final int timeout;
    private final boolean proxyRequired;
    private final Optional<ConnectionLimitUpstreamHandler> connectionLimitUpstreamHandler;
    private final Optional<ConnectionPerIpLimitUpstreamHandler> connectionPerIpLimitUpstreamHandler;
    private final ChannelHandlerFactory frameHandlerFactory;
    private final EventExecutorGroup eventExecutorGroup;

    public AbstractChannelPipelineFactory(ChannelHandlerFactory frameHandlerFactory, EventExecutorGroup eventExecutorGroup) {
        this(0, 0, 0, false, frameHandlerFactory, eventExecutorGroup);
    }

    public AbstractChannelPipelineFactory(int timeout, int maxConnections, int maxConnectsPerIp, boolean proxyRequired, ChannelHandlerFactory frameHandlerFactory, EventExecutorGroup eventExecutorGroup) {
        this.timeout = timeout;
        this.proxyRequired = proxyRequired;
        this.frameHandlerFactory = frameHandlerFactory;
        this.eventExecutorGroup = eventExecutorGroup;
        this.connectionLimitUpstreamHandler = ConnectionLimitUpstreamHandler.forCount(maxConnections);
        this.connectionPerIpLimitUpstreamHandler = ConnectionPerIpLimitUpstreamHandler.forCount(maxConnectsPerIp);
    }

    protected void initChannel(C channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        this.connectionLimitUpstreamHandler.ifPresent(handler -> pipeline.addLast("connectionLimitHandler", (ChannelHandler)handler));
        this.connectionPerIpLimitUpstreamHandler.ifPresent(handler -> pipeline.addLast("connectionPerIpLimitHandler", (ChannelHandler)handler));
        if (this.proxyRequired) {
            pipeline.addLast("proxyHandler", (ChannelHandler)new HAProxyMessageDecoder());
        }
        pipeline.addLast("chunkHandler", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("timeoutHandler", (ChannelHandler)new TimeoutHandler(this.timeout));
        pipeline.addLast(this.eventExecutorGroup, "framer", this.frameHandlerFactory.create(pipeline));
        pipeline.addLast(this.eventExecutorGroup, "coreHandler", (ChannelHandler)this.createHandler());
    }

    protected abstract ChannelInboundHandlerAdapter createHandler();
}

