/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.inject.Inject;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.export.api.BlobExportMechanism;
import org.apache.james.blob.export.api.FileExtension;
import org.apache.james.core.Username;
import org.apache.james.mailbox.backup.MailboxBackup;
import org.apache.james.task.Task;
import org.apache.james.user.api.UsersRepository;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ExportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportService.class);
    private static final String EXPLANATION = "The backup of your mailboxes has been exported to you";
    private static final String FILE_PREFIX = "mailbox-backup-";
    private final MailboxBackup mailboxBackup;
    private final BlobStore blobStore;
    private final BlobExportMechanism blobExport;
    private final UsersRepository usersRepository;

    @Inject
    ExportService(MailboxBackup mailboxBackup, BlobStore blobStore, BlobExportMechanism blobExport, UsersRepository usersRepository) {
        this.mailboxBackup = mailboxBackup;
        this.blobStore = blobStore;
        this.blobExport = blobExport;
        this.usersRepository = usersRepository;
    }

    public Mono<Task.Result> export(Progress progress, Username username) {
        return Mono.usingWhen((Publisher)Mono.fromCallable(() -> this.zipMailboxesContent(progress, username)), inputStream -> this.export(progress, username, (InputStream)inputStream), this::closeResource, (inputStream, throwable) -> this.closeResource((Closeable)inputStream), this::closeResource);
    }

    InputStream zipMailboxesContent(Progress progress, Username username) throws IOException {
        progress.setStage(Stage.ZIPPING);
        PipedOutputStream out = new PipedOutputStream();
        PipedInputStream in = new PipedInputStream(out);
        this.writeUserMailboxesContent(username, out).subscribeOn(Schedulers.boundedElastic()).subscribe();
        return in;
    }

    Mono<Task.Result> export(Progress progress, Username username, InputStream inputStream) {
        return Mono.fromRunnable(() -> progress.setStage(Stage.EXPORTING)).then(Mono.usingWhen((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), inputStream, BlobStore.StoragePolicy.LOW_COST), blobId -> this.export(username, (BlobId)blobId), this::deleteBlob).doOnSuccess(any -> progress.setStage(Stage.COMPLETED)).thenReturn((Object)Task.Result.COMPLETED).onErrorResume(e -> {
            LOGGER.error("Error exporting mailboxes of user: {}", (Object)username.asString(), e);
            return Mono.just((Object)Task.Result.PARTIAL);
        }));
    }

    private Mono<Void> export(Username username, BlobId blobId) {
        return Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.blobExport.blobId(blobId).with(this.usersRepository.getMailAddressFor(username)).explanation(EXPLANATION).filePrefix(FILE_PREFIX + username.asString() + "-").fileExtension(FileExtension.ZIP).export()).sneakyThrow()).subscribeOn(Schedulers.boundedElastic()).then();
    }

    private Mono<Void> deleteBlob(BlobId blobId) {
        return Mono.from((Publisher)this.blobStore.delete(this.blobStore.getDefaultBucketName(), blobId)).onErrorResume(e -> {
            LOGGER.error("Error deleting Blob with blobId: {}", (Object)blobId.asString(), e);
            return Mono.empty();
        }).then();
    }

    private Mono<Void> writeUserMailboxesContent(Username username, PipedOutputStream out) {
        return Mono.usingWhen((Publisher)Mono.fromCallable(() -> out), outputStream -> Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.mailboxBackup.backupAccount(username, (OutputStream)outputStream))), this::closeResource, (outputStream, throwable) -> this.closeResource((Closeable)outputStream).doFinally(any -> LOGGER.error("Error while backing up mailboxes for user {}", (Object)username.asString(), throwable)), this::closeResource);
    }

    private Mono<Void> closeResource(Closeable resource) {
        return Mono.fromRunnable(() -> {
            try {
                resource.close();
            }
            catch (IOException e) {
                LOGGER.error("Error while closing resource", (Throwable)e);
            }
        });
    }

    public static class Progress {
        private final ConcurrentLinkedDeque<Stage> stages = new ConcurrentLinkedDeque(Lists.newArrayList((Object[])new Stage[]{Stage.STARTING}));

        public Stage getStage() {
            return this.stages.getLast();
        }

        public void setStage(Stage stage) {
            this.stages.add(stage);
        }
    }

    public static enum Stage {
        STARTING,
        ZIPPING,
        EXPORTING,
        COMPLETED;

    }
}

