/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.delete;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatementBuilder;
import com.datastax.oss.driver.api.querybuilder.BindMarker;
import com.datastax.oss.driver.api.querybuilder.condition.Condition;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.delete.DeleteSelection;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.internal.querybuilder.select.ElementSelector;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultDelete
implements DeleteSelection,
Delete {
    private final CqlIdentifier keyspace;
    private final CqlIdentifier table;
    private final ImmutableList<Selector> selectors;
    private final ImmutableList<Relation> relations;
    private final Object timestamp;
    private final boolean ifExists;
    private final ImmutableList<Condition> conditions;

    public DefaultDelete(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier table) {
        this(keyspace, table, (ImmutableList<Selector>)ImmutableList.of(), (ImmutableList<Relation>)ImmutableList.of(), null, false, (ImmutableList<Condition>)ImmutableList.of());
    }

    public DefaultDelete(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier table, @NonNull ImmutableList<Selector> selectors, @NonNull ImmutableList<Relation> relations, @Nullable Object timestamp, boolean ifExists, @NonNull ImmutableList<Condition> conditions) {
        this.keyspace = keyspace;
        this.table = table;
        this.selectors = selectors;
        this.relations = relations;
        this.timestamp = timestamp;
        this.ifExists = ifExists;
        this.conditions = conditions;
    }

    @Override
    @NonNull
    public DeleteSelection selector(@NonNull Selector selector) {
        return this.withSelectors(ImmutableCollections.append(this.selectors, selector));
    }

    @Override
    @NonNull
    public DeleteSelection selectors(@NonNull Iterable<Selector> additionalSelectors) {
        return this.withSelectors(ImmutableCollections.concat(this.selectors, additionalSelectors));
    }

    @NonNull
    public DeleteSelection withSelectors(@NonNull ImmutableList<Selector> newSelectors) {
        return new DefaultDelete(this.keyspace, this.table, newSelectors, this.relations, this.timestamp, this.ifExists, this.conditions);
    }

    @Override
    @NonNull
    public Delete where(@NonNull Relation relation) {
        return this.withRelations(ImmutableCollections.append(this.relations, relation));
    }

    @Override
    @NonNull
    public Delete where(@NonNull Iterable<Relation> additionalRelations) {
        return this.withRelations(ImmutableCollections.concat(this.relations, additionalRelations));
    }

    @NonNull
    public Delete withRelations(@NonNull ImmutableList<Relation> newRelations) {
        return new DefaultDelete(this.keyspace, this.table, this.selectors, newRelations, this.timestamp, this.ifExists, this.conditions);
    }

    @Override
    @NonNull
    public DeleteSelection usingTimestamp(long newTimestamp) {
        return new DefaultDelete(this.keyspace, this.table, this.selectors, this.relations, newTimestamp, this.ifExists, this.conditions);
    }

    @Override
    @NonNull
    public DeleteSelection usingTimestamp(@Nullable BindMarker newTimestamp) {
        return new DefaultDelete(this.keyspace, this.table, this.selectors, this.relations, newTimestamp, this.ifExists, this.conditions);
    }

    @Override
    @NonNull
    public Delete ifExists() {
        return new DefaultDelete(this.keyspace, this.table, this.selectors, this.relations, this.timestamp, true, (ImmutableList<Condition>)ImmutableList.of());
    }

    @Override
    @NonNull
    public Delete if_(@NonNull Condition condition) {
        return this.withConditions(ImmutableCollections.append(this.conditions, condition));
    }

    @Override
    @NonNull
    public Delete if_(@NonNull Iterable<Condition> additionalConditions) {
        return this.withConditions(ImmutableCollections.concat(this.conditions, additionalConditions));
    }

    @NonNull
    public Delete withConditions(@NonNull ImmutableList<Condition> newConditions) {
        return new DefaultDelete(this.keyspace, this.table, this.selectors, this.relations, this.timestamp, false, newConditions);
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder("DELETE");
        CqlHelper.append(this.selectors, builder, " ", ",", null);
        builder.append(" FROM ");
        CqlHelper.qualify(this.keyspace, this.table, builder);
        if (this.timestamp != null) {
            builder.append(" USING TIMESTAMP ");
            if (this.timestamp instanceof BindMarker) {
                ((BindMarker)this.timestamp).appendTo(builder);
            } else {
                builder.append(this.timestamp);
            }
        }
        CqlHelper.append(this.relations, builder, " WHERE ", " AND ", null);
        if (this.ifExists) {
            builder.append(" IF EXISTS");
        } else {
            CqlHelper.append(this.conditions, builder, " IF ", " AND ", null);
        }
        return builder.toString();
    }

    @Override
    @NonNull
    public SimpleStatement build() {
        return this.builder().build();
    }

    @Override
    @NonNull
    public SimpleStatement build(Object ... values) {
        return this.builder().addPositionalValues(values).build();
    }

    @Override
    @NonNull
    public SimpleStatement build(@NonNull Map<String, Object> namedValues) {
        SimpleStatementBuilder builder = this.builder();
        for (Map.Entry<String, Object> entry : namedValues.entrySet()) {
            builder.addNamedValue(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    @Override
    @NonNull
    public SimpleStatementBuilder builder() {
        return (SimpleStatementBuilder)SimpleStatement.builder((String)this.asCql()).setIdempotence(Boolean.valueOf(this.isIdempotent()));
    }

    public boolean isIdempotent() {
        if (!this.conditions.isEmpty() || this.ifExists) {
            return false;
        }
        for (Selector selector : this.selectors) {
            if (!(selector instanceof ElementSelector)) continue;
            return false;
        }
        for (Relation relation : this.relations) {
            if (relation.isIdempotent()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @NonNull
    public CqlIdentifier getTable() {
        return this.table;
    }

    @NonNull
    public ImmutableList<Selector> getSelectors() {
        return this.selectors;
    }

    @NonNull
    public ImmutableList<Relation> getRelations() {
        return this.relations;
    }

    @Nullable
    public Object getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.asCql();
    }
}

