/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.mac;

import com.google.crypto.tink.mac.MacParameters;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.util.Objects;

public final class AesCmacParameters
extends MacParameters {
    private final int tagSizeBytes;
    private final Variant variant;

    private AesCmacParameters(int tagSizeBytes, Variant variant) {
        this.tagSizeBytes = tagSizeBytes;
        this.variant = variant;
    }

    public static AesCmacParameters create(int tagSize) throws GeneralSecurityException {
        return AesCmacParameters.createForKeysetWithCryptographicTagSize(tagSize, Variant.NO_PREFIX);
    }

    public static AesCmacParameters createForKeysetWithCryptographicTagSize(int tagSizeBytes, Variant variant) throws GeneralSecurityException {
        if (tagSizeBytes < 10 || 16 < tagSizeBytes) {
            throw new GeneralSecurityException("Invalid tag size for AesCmacParameters: " + tagSizeBytes);
        }
        return new AesCmacParameters(tagSizeBytes, variant);
    }

    public int getCryptographicTagSizeBytes() {
        return this.tagSizeBytes;
    }

    public int getTotalTagSizeBytes() {
        if (this.variant == Variant.NO_PREFIX) {
            return this.getCryptographicTagSizeBytes();
        }
        if (this.variant == Variant.TINK) {
            return this.getCryptographicTagSizeBytes() + 5;
        }
        if (this.variant == Variant.CRUNCHY) {
            return this.getCryptographicTagSizeBytes() + 5;
        }
        if (this.variant == Variant.LEGACY) {
            return this.getCryptographicTagSizeBytes() + 5;
        }
        throw new IllegalStateException("Unknown variant");
    }

    public Variant getVariant() {
        return this.variant;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AesCmacParameters)) {
            return false;
        }
        AesCmacParameters that = (AesCmacParameters)o;
        return that.getTotalTagSizeBytes() == this.getTotalTagSizeBytes() && that.getVariant() == this.getVariant();
    }

    public int hashCode() {
        return Objects.hash(this.tagSizeBytes, this.variant);
    }

    @Override
    public boolean hasIdRequirement() {
        return this.variant != Variant.NO_PREFIX;
    }

    public String toString() {
        return "AES-CMAC Parameters (variant: " + this.variant + ", " + this.tagSizeBytes + "-byte tags)";
    }

    @Immutable
    public static final class Variant {
        public static final Variant TINK = new Variant("TINK");
        public static final Variant CRUNCHY = new Variant("CRUNCHY");
        public static final Variant LEGACY = new Variant("LEGACY");
        public static final Variant NO_PREFIX = new Variant("NO_PREFIX");
        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

