/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class IcuFoldingTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final String unicodeSetFilter;
    public static final JsonpDeserializer<IcuFoldingTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IcuFoldingTokenFilter::setupIcuFoldingTokenFilterDeserializer);

    private IcuFoldingTokenFilter(Builder builder) {
        super(builder);
        this.unicodeSetFilter = ApiTypeHelper.requireNonNull(builder.unicodeSetFilter, this, "unicodeSetFilter");
    }

    public static IcuFoldingTokenFilter of(Function<Builder, ObjectBuilder<IcuFoldingTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.IcuFolding;
    }

    public final String unicodeSetFilter() {
        return this.unicodeSetFilter;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "icu_folding");
        super.serializeInternal(generator, mapper);
        generator.writeKey("unicode_set_filter");
        generator.write(this.unicodeSetFilter);
    }

    protected static void setupIcuFoldingTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::unicodeSetFilter, JsonpDeserializer.stringDeserializer(), "unicode_set_filter");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IcuFoldingTokenFilter> {
        private String unicodeSetFilter;

        public final Builder unicodeSetFilter(String value) {
            this.unicodeSetFilter = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IcuFoldingTokenFilter build() {
            this._checkSingleUse();
            return new IcuFoldingTokenFilter(this);
        }
    }
}

