/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.io;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.io.TextInputStream;
import org.apache.james.mime4j.util.ContentUtil;
import org.junit.Assert;
import org.junit.Test;

public class TextInputStreamTest {
    private static final String SWISS_GERMAN_HELLO = "Gr\u00fcezi_z\u00e4m\u00e4";
    private static final String RUSSIAN_HELLO = "\u0412\u0441\u0435\u043c_\u043f\u0440\u0438\u0432\u0435\u0442";
    private static final String TEST_STRING = "Hello and stuff Gr\u00fcezi_z\u00e4m\u00e4 \u0412\u0441\u0435\u043c_\u043f\u0440\u0438\u0432\u0435\u0442";
    private static final String LARGE_TEST_STRING;

    private static void singleByteReadTest(String testString) throws IOException {
        byte[] bytes = ContentUtil.toByteArray((String)testString, (Charset)Charsets.UTF_8);
        TextInputStream in = new TextInputStream((CharSequence)testString, Charsets.UTF_8, 1024);
        for (byte b : bytes) {
            int read = in.read();
            Assert.assertTrue((read >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((read <= 255 ? 1 : 0) != 0);
            Assert.assertEquals((long)b, (long)((byte)read));
        }
        in.close();
        Assert.assertEquals((long)-1L, (long)in.read());
    }

    private static void bufferedReadTest(String testString) throws IOException {
        SecureRandom rnd = new SecureRandom();
        byte[] expected = ContentUtil.toByteArray((String)testString, (Charset)Charsets.UTF_8);
        TextInputStream in = new TextInputStream((CharSequence)testString, Charsets.UTF_8, 1024);
        byte[] buffer = new byte[128];
        int offset = 0;
        block0: while (true) {
            int bufferLength;
            int bufferOffset;
            int read;
            if ((read = in.read(buffer, bufferOffset = rnd.nextInt(64), bufferLength = rnd.nextInt(64))) == -1) {
                Assert.assertEquals((long)offset, (long)expected.length);
                break;
            }
            Assert.assertTrue((read <= bufferLength ? 1 : 0) != 0);
            while (true) {
                if (read <= 0) continue block0;
                Assert.assertTrue((offset < expected.length ? 1 : 0) != 0);
                Assert.assertEquals((long)expected[offset], (long)buffer[bufferOffset]);
                ++offset;
                ++bufferOffset;
                --read;
            }
            break;
        }
        in.close();
    }

    @Test
    public void testSingleByteRead() throws IOException {
        TextInputStreamTest.singleByteReadTest(TEST_STRING);
    }

    @Test
    public void testLargeSingleByteRead() throws IOException {
        TextInputStreamTest.singleByteReadTest(LARGE_TEST_STRING);
    }

    @Test
    public void testBufferedRead() throws IOException {
        TextInputStreamTest.bufferedReadTest(TEST_STRING);
    }

    @Test
    public void testLargeBufferedRead() throws IOException {
        TextInputStreamTest.bufferedReadTest(LARGE_TEST_STRING);
    }

    @Test
    public void testReadZero() throws Exception {
        TextInputStream r = new TextInputStream((CharSequence)"test", Charsets.UTF_8, 1024);
        byte[] bytes = new byte[30];
        Assert.assertEquals((long)0L, (long)r.read(bytes, 0, 0));
        r.close();
    }

    @Test
    public void testReadZero2() throws Exception {
        TextInputStream r = new TextInputStream((CharSequence)"test", Charsets.US_ASCII, 1024);
        byte[] bytes = new byte[30];
        Assert.assertEquals((long)2L, (long)r.read(bytes, 0, 2));
        Assert.assertEquals((long)0L, (long)r.read(bytes, 2, 0));
        Assert.assertEquals((long)0L, (long)r.read(bytes, 2, 0));
        Assert.assertEquals((long)2L, (long)r.read(bytes, 2, 2));
        Assert.assertEquals((long)-1L, (long)r.read(bytes, 4, 0));
        Assert.assertEquals((long)-1L, (long)r.read(bytes, 4, 2));
    }

    @Test
    public void testSkip() throws Exception {
        TextInputStream r = new TextInputStream((CharSequence)"test", Charsets.UTF_8, 1024);
        r.skip(1L);
        r.skip(2L);
        Assert.assertEquals((long)116L, (long)r.read());
        r.skip(100L);
        Assert.assertEquals((long)-1L, (long)r.read());
        r.close();
    }

    @Test
    public void testMarkReset() throws Exception {
        TextInputStream r = new TextInputStream((CharSequence)"test", Charsets.UTF_8, 1024);
        r.skip(2L);
        r.mark(0);
        Assert.assertEquals((long)115L, (long)r.read());
        Assert.assertEquals((long)116L, (long)r.read());
        Assert.assertEquals((long)-1L, (long)r.read());
        r.reset();
        Assert.assertEquals((long)115L, (long)r.read());
        Assert.assertEquals((long)116L, (long)r.read());
        Assert.assertEquals((long)-1L, (long)r.read());
        r.reset();
        r.reset();
        r.close();
    }

    static {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            buffer.append(TEST_STRING);
        }
        LARGE_TEST_STRING = buffer.toString();
    }
}

