/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.pst;

import com.pff.PSTAttachment;
import com.pff.PSTException;
import com.pff.PSTFile;
import com.pff.PSTFolder;
import com.pff.PSTMessage;
import com.pff.PSTRecipient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Message;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OutlookExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class OutlookPSTParser
extends AbstractParser {
    public static final MediaType MS_OUTLOOK_PST_MIMETYPE = MediaType.application("vnd.ms-outlook-pst");
    private static final long serialVersionUID = 620998217748364063L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MS_OUTLOOK_PST_MIMETYPE);

    private static AttributesImpl createAttribute(String attName, String attValue) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", attName, attName, "CDATA", attValue);
        return attributes;
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        EmbeddedDocumentExtractor embeddedExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(context);
        metadata.set("Content-Type", MS_OUTLOOK_PST_MIMETYPE.toString());
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        TikaInputStream in = TikaInputStream.get(stream);
        PSTFile pstFile = null;
        try {
            pstFile = new PSTFile(in.getFile().getPath());
            metadata.set("Content-Length", String.valueOf(pstFile.getFileHandle().length()));
            boolean isValid = pstFile.getFileHandle().getFD().valid();
            metadata.set("isValid", String.valueOf(isValid));
            if (pstFile.getPSTFileType() == 36) {
                throw new TikaException("OST 2013 support not added yet. It will be when https://github.com/rjohnsondev/java-libpst/issues/60 is fixed.");
            }
            if (isValid) {
                this.parseFolder(xhtml, pstFile.getRootFolder(), embeddedExtractor);
            }
        }
        catch (TikaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TikaException(e.getMessage(), e);
        }
        finally {
            if (pstFile != null && pstFile.getFileHandle() != null) {
                try {
                    pstFile.getFileHandle().close();
                }
                catch (IOException iOException) {}
            }
        }
        xhtml.endDocument();
    }

    private void parseFolder(XHTMLContentHandler handler, PSTFolder pstFolder, EmbeddedDocumentExtractor embeddedExtractor) throws Exception {
        if (pstFolder.getContentCount() > 0) {
            PSTMessage pstMail = (PSTMessage)pstFolder.getNextChild();
            while (pstMail != null) {
                this.parseMailAndAttachments(handler, pstMail, embeddedExtractor);
                pstMail = (PSTMessage)pstFolder.getNextChild();
            }
        }
        if (pstFolder.hasSubfolders()) {
            for (PSTFolder pstSubFolder : pstFolder.getSubFolders()) {
                handler.startElement("div", OutlookPSTParser.createAttribute("class", "email-folder"));
                handler.element("h1", pstSubFolder.getDisplayName());
                this.parseFolder(handler, pstSubFolder, embeddedExtractor);
                handler.endElement("div");
            }
        }
    }

    private void parseMailAndAttachments(XHTMLContentHandler handler, PSTMessage pstMail, EmbeddedDocumentExtractor embeddedExtractor) throws SAXException, IOException, TikaException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "class", "class", "CDATA", "embedded");
        attributes.addAttribute("", "id", "id", "CDATA", pstMail.getInternetMessageId());
        handler.startElement("div", attributes);
        handler.element("h1", pstMail.getSubject());
        Metadata mailMetadata = new Metadata();
        this.parseMailAttachments(handler, pstMail, mailMetadata, embeddedExtractor);
        this.parserMailItem(handler, pstMail, mailMetadata, embeddedExtractor);
        handler.endElement("div");
    }

    private void parserMailItem(XHTMLContentHandler handler, PSTMessage pstMail, Metadata mailMetadata, EmbeddedDocumentExtractor embeddedExtractor) throws SAXException, IOException {
        mailMetadata.set("resourceName", pstMail.getInternetMessageId());
        mailMetadata.set("embeddedRelationshipId", pstMail.getInternetMessageId());
        mailMetadata.set(TikaCoreProperties.IDENTIFIER, pstMail.getInternetMessageId());
        mailMetadata.set(TikaCoreProperties.TITLE, pstMail.getSubject());
        mailMetadata.set("Message-From", pstMail.getSenderName());
        mailMetadata.set(TikaCoreProperties.CREATOR, pstMail.getSenderName());
        mailMetadata.set(TikaCoreProperties.CREATED, pstMail.getCreationTime());
        mailMetadata.set(Office.MAPI_MESSAGE_CLIENT_SUBMIT_TIME, pstMail.getClientSubmitTime());
        mailMetadata.set(TikaCoreProperties.MODIFIED, pstMail.getLastModificationTime());
        mailMetadata.set(TikaCoreProperties.COMMENTS, pstMail.getComment());
        mailMetadata.set("descriptorNodeId", String.valueOf(pstMail.getDescriptorNodeId()));
        mailMetadata.set("senderEmailAddress", pstMail.getSenderEmailAddress());
        mailMetadata.set("recipients", pstMail.getRecipientsString());
        mailMetadata.set("displayTo", pstMail.getDisplayTo());
        mailMetadata.set("displayCC", pstMail.getDisplayCC());
        mailMetadata.set("displayBCC", pstMail.getDisplayBCC());
        mailMetadata.set("importance", String.valueOf(pstMail.getImportance()));
        mailMetadata.set("priority", String.valueOf(pstMail.getPriority()));
        mailMetadata.set("flagged", String.valueOf(pstMail.isFlagged()));
        mailMetadata.set(Office.MAPI_MESSAGE_CLASS, OutlookExtractor.getMessageClass(pstMail.getMessageClass()));
        mailMetadata.set(Message.MESSAGE_FROM_EMAIL, pstMail.getSenderEmailAddress());
        mailMetadata.set(Office.MAPI_FROM_REPRESENTING_EMAIL, pstMail.getSentRepresentingEmailAddress());
        mailMetadata.set(Message.MESSAGE_FROM_NAME, pstMail.getSenderName());
        mailMetadata.set(Office.MAPI_FROM_REPRESENTING_NAME, pstMail.getSentRepresentingName());
        try {
            block7: for (int i = 0; i < pstMail.getNumberOfRecipients(); ++i) {
                PSTRecipient recipient = pstMail.getRecipient(i);
                switch (OutlookExtractor.RECIPIENT_TYPE.getTypeFromVal(recipient.getRecipientType())) {
                    case TO: {
                        OutlookExtractor.addEvenIfNull(Message.MESSAGE_TO_DISPLAY_NAME, recipient.getDisplayName(), mailMetadata);
                        OutlookExtractor.addEvenIfNull(Message.MESSAGE_TO_EMAIL, recipient.getEmailAddress(), mailMetadata);
                        continue block7;
                    }
                    case CC: {
                        OutlookExtractor.addEvenIfNull(Message.MESSAGE_CC_DISPLAY_NAME, recipient.getDisplayName(), mailMetadata);
                        OutlookExtractor.addEvenIfNull(Message.MESSAGE_CC_EMAIL, recipient.getEmailAddress(), mailMetadata);
                        continue block7;
                    }
                    case BCC: {
                        OutlookExtractor.addEvenIfNull(Message.MESSAGE_BCC_DISPLAY_NAME, recipient.getDisplayName(), mailMetadata);
                        OutlookExtractor.addEvenIfNull(Message.MESSAGE_BCC_EMAIL, recipient.getEmailAddress(), mailMetadata);
                        continue block7;
                    }
                }
            }
        }
        catch (PSTException i) {
            // empty catch block
        }
        byte[] mailContent = pstMail.getBody().getBytes(StandardCharsets.UTF_8);
        mailMetadata.set(TikaCoreProperties.CONTENT_TYPE_USER_OVERRIDE, MediaType.TEXT_PLAIN.toString());
        embeddedExtractor.parseEmbedded(new ByteArrayInputStream(mailContent), handler, mailMetadata, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMailAttachments(XHTMLContentHandler xhtml, PSTMessage email, Metadata mailMetadata, EmbeddedDocumentExtractor embeddedExtractor) throws TikaException {
        int numberOfAttachments = email.getNumberOfAttachments();
        for (int i = 0; i < numberOfAttachments; ++i) {
            try {
                PSTAttachment attach = email.getAttachment(i);
                PSTMessage attachedEmail = attach.getEmbeddedPSTMessage();
                if (attachedEmail != null) {
                    this.parseMailAndAttachments(xhtml, attachedEmail, embeddedExtractor);
                    continue;
                }
                String filename = attach.getLongFilename();
                if (filename.isEmpty()) {
                    filename = attach.getFilename();
                }
                xhtml.element("p", filename);
                Metadata attachMeta = new Metadata();
                attachMeta.set("resourceName", filename);
                attachMeta.set("embeddedRelationshipId", filename);
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "class", "class", "CDATA", "embedded");
                attributes.addAttribute("", "id", "id", "CDATA", filename);
                xhtml.startElement("div", attributes);
                if (embeddedExtractor.shouldParseEmbedded(attachMeta)) {
                    TikaInputStream tis = null;
                    try {
                        tis = TikaInputStream.get(attach.getFileInputStream());
                    }
                    catch (NullPointerException e) {
                        EmbeddedDocumentUtil.recordEmbeddedStreamException(e, mailMetadata);
                        continue;
                    }
                    try {
                        embeddedExtractor.parseEmbedded(tis, xhtml, attachMeta, false);
                    }
                    finally {
                        tis.close();
                    }
                }
                xhtml.endElement("div");
                continue;
            }
            catch (Exception e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException(e, mailMetadata);
            }
        }
    }
}

