/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.principal.GroupPrincipal;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.commons.flat.BTreeManager;
import org.apache.jackrabbit.commons.flat.ItemSequence;
import org.apache.jackrabbit.commons.flat.PropertySequence;
import org.apache.jackrabbit.commons.flat.Rank;
import org.apache.jackrabbit.commons.iterator.LazyIteratorChain;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.security.user.AuthorizableImpl;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionWriteOperation;
import org.apache.jackrabbit.spi.commons.iterator.Iterators;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GroupImpl
extends AuthorizableImpl
implements Group {
    private static final Logger log = LoggerFactory.getLogger(GroupImpl.class);
    private Principal principal;

    protected GroupImpl(NodeImpl node, UserManagerImpl userManager) {
        super(node, userManager);
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    @Override
    public Principal getPrincipal() throws RepositoryException {
        if (this.principal == null) {
            this.principal = new NodeBasedGroup(this.getPrincipalName());
        }
        return this.principal;
    }

    @Override
    public Iterator<Authorizable> getDeclaredMembers() throws RepositoryException {
        if (this.isEveryone()) {
            return this.userManager.findAuthorizables(this.getSession().getJCRName(P_PRINCIPAL_NAME), null, 3);
        }
        return this.getMembers(false, 3);
    }

    @Override
    public Iterator<Authorizable> getMembers() throws RepositoryException {
        if (this.isEveryone()) {
            return this.getDeclaredMembers();
        }
        return this.getMembers(true, 3);
    }

    @Override
    public boolean isDeclaredMember(Authorizable authorizable) throws RepositoryException {
        if (authorizable == null || !(authorizable instanceof AuthorizableImpl) || this.getNode().isSame(((AuthorizableImpl)authorizable).getNode())) {
            return false;
        }
        if (this.isEveryone()) {
            return true;
        }
        return this.getMembershipProvider(this.getNode()).hasMember((AuthorizableImpl)authorizable);
    }

    @Override
    public boolean isMember(Authorizable authorizable) throws RepositoryException {
        if (authorizable == null || !(authorizable instanceof AuthorizableImpl) || this.getNode().isSame(((AuthorizableImpl)authorizable).getNode())) {
            return false;
        }
        if (this.isEveryone()) {
            return true;
        }
        String thisID = this.getID();
        AuthorizableImpl impl = (AuthorizableImpl)authorizable;
        Iterator<Group> it = impl.memberOf();
        while (it.hasNext()) {
            if (!thisID.equals(it.next().getID())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addMember(Authorizable authorizable) throws RepositoryException {
        if (!(authorizable instanceof AuthorizableImpl)) {
            log.warn("Invalid Authorizable: {}", (Object)authorizable);
            return false;
        }
        if (this.isEveryone() || ((AuthorizableImpl)authorizable).isEveryone()) {
            return false;
        }
        AuthorizableImpl authImpl = (AuthorizableImpl)authorizable;
        NodeImpl memberNode = authImpl.getNode();
        if (memberNode.isSame(this.getNode())) {
            String msg = "Attempt to add a group as member of itself (" + this.getID() + ").";
            log.warn(msg);
            return false;
        }
        if (this.isCyclicMembership(authImpl)) {
            log.warn("Attempt to create circular group membership.");
            return false;
        }
        return this.getMembershipProvider(this.getNode()).addMember(authImpl);
    }

    @Override
    public Set<String> addMembers(String ... memberIds) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("not implemented");
    }

    @Override
    public boolean removeMember(Authorizable authorizable) throws RepositoryException {
        if (!(authorizable instanceof AuthorizableImpl)) {
            log.warn("Invalid Authorizable: {}", (Object)authorizable);
            return false;
        }
        if (this.isEveryone()) {
            return false;
        }
        return this.getMembershipProvider(this.getNode()).removeMember((AuthorizableImpl)authorizable);
    }

    @Override
    public Set<String> removeMembers(String ... memberIds) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("not implemented");
    }

    private MembershipProvider getMembershipProvider(NodeImpl node) throws RepositoryException {
        MembershipProvider msp = this.userManager.hasMemberSplitSize() ? (node.hasNode(N_MEMBERS) || !node.hasProperty(P_MEMBERS) ? new NodeBasedMembershipProvider(node) : new PropertyBasedMembershipProvider(node)) : new PropertyBasedMembershipProvider(node);
        if (node.hasProperty(P_MEMBERS) && node.hasNode(N_MEMBERS)) {
            log.warn("Found members node and members property on node {}. Ignoring {} members", (Object)node, (Object)(this.userManager.hasMemberSplitSize() ? "property" : "node"));
        }
        return msp;
    }

    private Iterator<Authorizable> getMembers(boolean includeIndirect, int type) throws RepositoryException {
        return this.getMembershipProvider(this.getNode()).getMembers(includeIndirect, type);
    }

    private boolean isCyclicMembership(AuthorizableImpl newMember) throws RepositoryException {
        if (newMember.isGroup()) {
            GroupImpl gr = (GroupImpl)newMember;
            Iterator<Authorizable> it = gr.getMembers(true, 2);
            while (it.hasNext()) {
                Authorizable member = it.next();
                GroupImpl grMemberImpl = (GroupImpl)member;
                if (!this.getNode().getUUID().equals(grMemberImpl.getNode().getUUID())) continue;
                return true;
            }
        }
        return false;
    }

    private String safeGetID() {
        try {
            return this.getID();
        }
        catch (RepositoryException e) {
            return this.getNode().toString();
        }
    }

    static PropertySequence getPropertySequence(Node nMembers, UserManagerImpl userManager) throws RepositoryException {
        Comparator<String> order = Rank.comparableComparator();
        int maxChildren = userManager.getMemberSplitSize();
        int minChildren = maxChildren / 2;
        BTreeManager treeManager = new BTreeManager(nMembers, minChildren, maxChildren, order, userManager.isAutoSave());
        return ItemSequence.createPropertySequence(treeManager);
    }

    private Iterator<Authorizable> includeIndirect(final Iterator<Authorizable> authorizables, final int type) {
        Iterator<Iterator<Authorizable>> indirectMembers = new Iterator<Iterator<Authorizable>>(){

            @Override
            public boolean hasNext() {
                return authorizables.hasNext();
            }

            @Override
            public Iterator<Authorizable> next() {
                Authorizable next = (Authorizable)authorizables.next();
                return Iterators.iteratorChain(Iterators.singleton(next), this.indirect(next));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private Iterator<Authorizable> indirect(Authorizable authorizable) {
                if (authorizable.isGroup()) {
                    try {
                        return ((GroupImpl)authorizable).getMembers(true, type);
                    }
                    catch (RepositoryException e) {
                        log.warn("Could not determine members of " + String.valueOf(authorizable), e);
                    }
                }
                return Iterators.empty();
            }
        };
        return this.unique(new LazyIteratorChain<Authorizable>(indirectMembers));
    }

    private Iterator<Authorizable> unique(Iterator<Authorizable> authorizables) {
        final HashSet seenAuthorizables = new HashSet();
        return Iterators.filterIterator(authorizables, new Predicate<Authorizable>(){

            @Override
            public boolean test(Authorizable authorizable) {
                try {
                    return seenAuthorizables.add(authorizable.getID());
                }
                catch (RepositoryException e) {
                    log.warn("Could not determine id of " + String.valueOf(authorizable), e);
                    return true;
                }
            }
        });
    }

    private Iterator<Authorizable> toAuthorizables(final Value[] members, int type) {
        return new AuthorizableIterator(type){
            private int pos;

            @Override
            protected String getNextMemberRef() throws RepositoryException {
                return this.pos < members.length ? members[this.pos++].getString() : null;
            }
        };
    }

    private Iterator<Authorizable> toAuthorizables(final Iterator<Property> members, int type) {
        return new AuthorizableIterator(type){

            @Override
            protected String getNextMemberRef() throws RepositoryException {
                return members.hasNext() ? ((Property)members.next()).getString() : null;
            }
        };
    }

    private abstract class AuthorizableIterator
    implements Iterator<Authorizable> {
        private Authorizable next;
        private final int type;

        public AuthorizableIterator(int type) {
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            this.prefetch();
            return this.next != null;
        }

        @Override
        public Authorizable next() {
            this.prefetch();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Authorizable element = this.next;
            this.next = null;
            return element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract String getNextMemberRef() throws RepositoryException;

        private void prefetch() {
            while (this.next == null) {
                try {
                    String memberRef = this.getNextMemberRef();
                    if (memberRef == null) {
                        return;
                    }
                    NodeImpl member = (NodeImpl)GroupImpl.this.getSession().getNodeByIdentifier(memberRef);
                    if (this.type != 1 && member.isNodeType(UserConstants.NT_REP_GROUP)) {
                        this.next = GroupImpl.this.userManager.createGroup(member);
                        continue;
                    }
                    if (this.type != 2 && member.isNodeType(UserConstants.NT_REP_USER)) {
                        this.next = GroupImpl.this.userManager.createUser(member);
                        continue;
                    }
                    log.debug("Group member entry with invalid node type {} -> Not included in member set.", (Object)member.getPrimaryNodeType().getName());
                }
                catch (ItemNotFoundException e) {
                    log.debug("Authorizable node referenced by {} doesn't exist any more -> Ignored from member list.", (Object)GroupImpl.this.safeGetID());
                }
                catch (RepositoryException e) {
                    log.debug("Error pre-fetching member for " + GroupImpl.this.safeGetID(), e);
                }
            }
        }
    }

    private class NodeBasedMembershipProvider
    implements MembershipProvider {
        private final NodeImpl node;

        private NodeBasedMembershipProvider(NodeImpl node) {
            this.node = node;
        }

        @Override
        public boolean addMember(final AuthorizableImpl authorizable) throws RepositoryException {
            return GroupImpl.this.userManager.performProtectedOperation(GroupImpl.this.getSession(), new SessionWriteOperation<Boolean>(){

                @Override
                public Boolean perform(SessionContext context) throws RepositoryException {
                    NodeImpl nMembers = NodeBasedMembershipProvider.this.node.hasNode(UserConstants.N_MEMBERS) ? NodeBasedMembershipProvider.this.node.getNode(UserConstants.N_MEMBERS) : NodeBasedMembershipProvider.this.node.addNode(UserConstants.N_MEMBERS, UserConstants.NT_REP_MEMBERS, null);
                    try {
                        PropertySequence properties = GroupImpl.getPropertySequence(nMembers, GroupImpl.this.userManager);
                        String propName = Text.escapeIllegalJcrChars(authorizable.getID());
                        if (properties.hasItem(propName)) {
                            log.debug("Authorizable {} is already member of {}", (Object)authorizable, (Object)this);
                            return false;
                        }
                        Value newMember = GroupImpl.this.getSession().getValueFactory().createValue(authorizable.getNode(), true);
                        properties.addProperty(propName, newMember);
                        if (GroupImpl.this.userManager.isAutoSave()) {
                            NodeBasedMembershipProvider.this.node.save();
                        }
                        return true;
                    }
                    catch (RepositoryException e) {
                        log.debug("addMember failed. Reverting changes", e);
                        if (nMembers.isNew()) {
                            NodeBasedMembershipProvider.this.node.refresh(false);
                        } else {
                            nMembers.refresh(false);
                        }
                        throw e;
                    }
                }
            });
        }

        @Override
        public boolean removeMember(final AuthorizableImpl authorizable) throws RepositoryException {
            if (!this.node.hasNode(UserConstants.N_MEMBERS)) {
                log.debug("Group has no members -> cannot remove member {}", (Object)authorizable.getID());
                return false;
            }
            return GroupImpl.this.userManager.performProtectedOperation(GroupImpl.this.getSession(), new SessionWriteOperation<Boolean>(){

                @Override
                public Boolean perform(SessionContext context) throws RepositoryException {
                    NodeImpl nMembers = NodeBasedMembershipProvider.this.node.getNode(UserConstants.N_MEMBERS);
                    try {
                        PropertySequence properties = GroupImpl.getPropertySequence(nMembers, GroupImpl.this.userManager);
                        String propName = Text.escapeIllegalJcrChars(authorizable.getID());
                        if (properties.hasItem(propName)) {
                            properties.removeProperty(propName);
                            if (!properties.iterator().hasNext()) {
                                nMembers.remove();
                            }
                        } else {
                            log.debug("Authorizable {} was not member of {}", (Object)authorizable.getID(), (Object)GroupImpl.this.getID());
                            return false;
                        }
                        if (GroupImpl.this.userManager.isAutoSave()) {
                            NodeBasedMembershipProvider.this.node.save();
                        }
                        return true;
                    }
                    catch (RepositoryException e) {
                        log.debug("removeMember failed. Reverting changes", e);
                        nMembers.refresh(false);
                        throw e;
                    }
                }
            });
        }

        @Override
        public Iterator<Authorizable> getMembers(boolean includeIndirect, int type) throws RepositoryException {
            if (this.node.hasNode(UserConstants.N_MEMBERS)) {
                PropertySequence members = GroupImpl.getPropertySequence(this.node.getNode(UserConstants.N_MEMBERS), GroupImpl.this.userManager);
                if (includeIndirect) {
                    return GroupImpl.this.includeIndirect(GroupImpl.this.toAuthorizables(members.iterator(), type), type);
                }
                return GroupImpl.this.toAuthorizables(members.iterator(), type);
            }
            return Iterators.empty();
        }

        @Override
        public boolean hasMember(AuthorizableImpl authorizable) throws RepositoryException {
            if (this.node.hasNode(UserConstants.N_MEMBERS)) {
                PropertySequence members = GroupImpl.getPropertySequence(this.node.getNode(UserConstants.N_MEMBERS), GroupImpl.this.userManager);
                return members.hasItem(authorizable.getID());
            }
            return false;
        }
    }

    private class PropertyBasedMembershipProvider
    implements MembershipProvider {
        private final NodeImpl node;

        private PropertyBasedMembershipProvider(NodeImpl node) {
            this.node = node;
        }

        @Override
        public boolean addMember(AuthorizableImpl authorizable) throws RepositoryException {
            Value[] values;
            NodeImpl memberNode = authorizable.getNode();
            Value toAdd = GroupImpl.this.getSession().getValueFactory().createValue(memberNode, true);
            if (this.node.hasProperty(UserConstants.P_MEMBERS)) {
                Value[] old;
                for (Value v : old = this.node.getProperty(UserConstants.P_MEMBERS).getValues()) {
                    if (!v.equals(toAdd)) continue;
                    log.debug("Authorizable {} is already member of {}", (Object)authorizable, (Object)this);
                    return false;
                }
                values = new Value[old.length + 1];
                System.arraycopy(old, 0, values, 0, old.length);
            } else {
                values = new Value[1];
            }
            values[values.length - 1] = toAdd;
            GroupImpl.this.userManager.setProtectedProperty(this.node, UserConstants.P_MEMBERS, values, 10);
            return true;
        }

        @Override
        public boolean removeMember(AuthorizableImpl authorizable) throws RepositoryException {
            if (!this.node.hasProperty(UserConstants.P_MEMBERS)) {
                log.debug("Group has no members -> cannot remove member {}", (Object)authorizable.getID());
                return false;
            }
            Value toRemove = GroupImpl.this.getSession().getValueFactory().createValue(authorizable.getNode(), true);
            PropertyImpl property = this.node.getProperty(UserConstants.P_MEMBERS);
            ArrayList<Value> valList = new ArrayList<Value>(Arrays.asList(property.getValues()));
            if (valList.remove(toRemove)) {
                try {
                    if (valList.isEmpty()) {
                        GroupImpl.this.userManager.removeProtectedItem(property, this.node);
                    } else {
                        Value[] values = valList.toArray(new Value[valList.size()]);
                        GroupImpl.this.userManager.setProtectedProperty(this.node, UserConstants.P_MEMBERS, values);
                    }
                    return true;
                }
                catch (RepositoryException e) {
                    this.node.refresh(false);
                    throw e;
                }
            }
            log.debug("Authorizable {} was not member of {}", (Object)authorizable.getID(), (Object)GroupImpl.this.getID());
            return false;
        }

        @Override
        public Iterator<Authorizable> getMembers(boolean includeIndirect, int type) throws RepositoryException {
            if (this.node.hasProperty(UserConstants.P_MEMBERS)) {
                Value[] members = this.node.getProperty(UserConstants.P_MEMBERS).getValues();
                if (includeIndirect) {
                    return GroupImpl.this.includeIndirect(GroupImpl.this.toAuthorizables(members, type), type);
                }
                return new RangeIteratorAdapter(GroupImpl.this.toAuthorizables(members, type), members.length);
            }
            return Iterators.empty();
        }

        @Override
        public boolean hasMember(AuthorizableImpl authorizable) throws RepositoryException {
            if (this.node.hasProperty(UserConstants.P_MEMBERS)) {
                Value[] members;
                for (Value v : members = this.node.getProperty(UserConstants.P_MEMBERS).getValues()) {
                    if (!authorizable.getNode().getIdentifier().equals(v.getString())) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    private static interface MembershipProvider {
        public boolean addMember(AuthorizableImpl var1) throws RepositoryException;

        public boolean removeMember(AuthorizableImpl var1) throws RepositoryException;

        public Iterator<Authorizable> getMembers(boolean var1, int var2) throws RepositoryException;

        public boolean hasMember(AuthorizableImpl var1) throws RepositoryException;
    }

    private class NodeBasedGroup
    extends AuthorizableImpl.NodeBasedPrincipal
    implements GroupPrincipal {
        private NodeBasedGroup(String name) {
            super(name);
        }

        public boolean addMember(Principal user) {
            return false;
        }

        public boolean removeMember(Principal user) {
            return false;
        }

        @Override
        public boolean isMember(Principal member) {
            try {
                if (GroupImpl.this.isEveryone()) {
                    return !GroupImpl.this.getPrincipal().equals(member);
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            Collection<Principal> members = this.getMembers();
            return members.contains(member);
        }

        @Override
        public Enumeration<? extends Principal> members() {
            return Collections.enumeration(this.getMembers());
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            this.getMembers();
            stream.defaultWriteObject();
        }

        private Collection<Principal> getMembers() {
            HashSet<Principal> members = new HashSet<Principal>();
            try {
                Iterator<Authorizable> it = GroupImpl.this.getMembers();
                while (it.hasNext()) {
                    members.add(it.next().getPrincipal());
                }
            }
            catch (RepositoryException e) {
                log.error("Unable to retrieve Group members.");
            }
            return members;
        }
    }
}

