/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.QueryObjectModelFactory;

public class Constraints {
    public static Constraint and(QueryObjectModelFactory factory, List<Constraint> constraints) throws RepositoryException {
        int n = constraints.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return constraints.get(0);
        }
        int m = n / 2;
        return factory.and(Constraints.and(factory, constraints.subList(0, m)), Constraints.and(factory, constraints.subList(m, n)));
    }

    public static Constraint and(QueryObjectModelFactory factory, Constraint ... constraints) throws RepositoryException {
        ArrayList<Constraint> list = new ArrayList<Constraint>(constraints.length);
        for (Constraint constraint : constraints) {
            if (constraint == null) continue;
            list.add(constraint);
        }
        return Constraints.and(factory, list);
    }

    public static Constraint or(QueryObjectModelFactory factory, List<Constraint> constraints) throws RepositoryException {
        int n = constraints.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return constraints.get(0);
        }
        int m = n / 2;
        return factory.or(Constraints.or(factory, constraints.subList(0, m)), Constraints.or(factory, constraints.subList(m, n)));
    }
}

