/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.runtime;

import io.quarkus.tls.runtime.TrustStoreAndTrustOptions;
import io.quarkus.tls.runtime.config.TrustStoreConfig;
import io.quarkus.tls.runtime.keystores.ExpiryTrustOptions;
import io.vertx.core.Vertx;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.KeyStoreHelper;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class JavaxNetSslTrustStoreProvider {
    public static TrustStoreAndTrustOptions getTrustStore(Vertx vertx) {
        JavaNetSslTrustOptions options = new JavaNetSslTrustOptions();
        return new TrustStoreAndTrustOptions(options.keystore, new ExpiryTrustOptions(options, TrustStoreConfig.CertificateExpiryPolicy.WARN));
    }

    static class JavaNetSslTrustOptions
    implements TrustOptions {
        private final TrustManagerFactory trustManagerFactory;
        private final KeyStore keystore;
        private KeyStoreHelper helper;

        JavaNetSslTrustOptions() {
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init((KeyStore)null);
                KeyStore cacerts = JavaNetSslTrustOptions.copyCerts(tmf);
                this.trustManagerFactory = tmf;
                this.keystore = cacerts;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException | InvalidNameException e) {
                throw new RuntimeException(e);
            }
        }

        static KeyStore copyCerts(TrustManagerFactory tmf) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, InvalidNameException {
            String tsType = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
            KeyStore cacerts = KeyStore.getInstance(tsType);
            cacerts.load(null, null);
            HashSet<String> aliases = new HashSet<String>();
            for (TrustManager tm : tmf.getTrustManagers()) {
                for (X509Certificate c : ((X509TrustManager)tm).getAcceptedIssuers()) {
                    String dn = c.getSubjectX500Principal().getName();
                    List<Rdn> rdns = new LdapName(dn).getRdns();
                    Object alias = rdns.stream().filter(rdn -> rdn.getType().equalsIgnoreCase("cn")).map(rdn -> rdn.getValue().toString()).findFirst().orElseGet(() -> rdns.stream().filter(rdn -> rdn.getType().equalsIgnoreCase("ou")).map(rdn -> rdn.getValue().toString()).findFirst().orElse(dn));
                    alias = ((String)alias).replace(" ", "");
                    if (aliases.contains(alias = ((String)alias).toLowerCase(Locale.ROOT))) {
                        int i = 1;
                        String indexedAlias = (String)alias + i;
                        while (aliases.contains(indexedAlias)) {
                            indexedAlias = (String)alias + ++i;
                        }
                        alias = indexedAlias;
                    }
                    aliases.add((String)alias);
                    cacerts.setCertificateEntry((String)alias, c);
                }
            }
            return cacerts;
        }

        public Function<String, TrustManager[]> trustManagerMapper(Vertx vertx) throws Exception {
            if (this.helper == null) {
                String cacertsPassword = System.getProperty("javax.net.ssl.trustStorePassword", "changeit");
                this.helper = new KeyStoreHelper(this.keystore, cacertsPassword, null);
            }
            return arg_0 -> ((KeyStoreHelper)this.helper).getTrustMgr(arg_0);
        }

        public TrustManagerFactory getTrustManagerFactory(Vertx vertx) {
            return this.trustManagerFactory;
        }

        public TrustOptions copy() {
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.keystore == null ? 0 : this.keystore.hashCode());
            return result;
        }
    }
}

