/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import javax.net.SocketFactory;

public interface ClientSocketFactory {
    public DatagramSocket createDatagramSocket() throws SocketException;

    public Socket createSocket() throws IOException;

    public InetAddress getAddress();

    public int getPort();

    default public SocketAddress getSocketAddress() {
        return new InetSocketAddress(this.getAddress(), this.getPort());
    }

    public static ClientSocketFactory of(InetAddress address, int port) {
        return ClientSocketFactory.of(SocketFactory.getDefault(), address, port);
    }

    public static ClientSocketFactory of(SocketFactory socketFactory, final InetAddress address, final int port) {
        if (address == null || port < 0) {
            throw new IllegalArgumentException(String.format("The address cannot be null (%s) and the port must be a positive integer (%d)", address, port));
        }
        final SocketFactory factory = socketFactory == null ? SocketFactory.getDefault() : socketFactory;
        return new ClientSocketFactory(){

            @Override
            public DatagramSocket createDatagramSocket() throws SocketException {
                return new DatagramSocket();
            }

            @Override
            public Socket createSocket() throws IOException {
                return factory.createSocket(address, port);
            }

            @Override
            public InetAddress getAddress() {
                return address;
            }

            @Override
            public int getPort() {
                return port;
            }
        };
    }
}

