/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.cache;

import java.time.Instant;
import org.apache.polaris.core.storage.StorageAccessConfig;

public class StorageCredentialCacheEntry {
    public final StorageAccessConfig storageAccessConfig;
    private final long maxCacheDurationMs;

    public StorageCredentialCacheEntry(StorageAccessConfig storageAccessConfig, long maxCacheDurationMs) {
        this.storageAccessConfig = storageAccessConfig;
        this.maxCacheDurationMs = maxCacheDurationMs;
    }

    public long getMaxCacheDurationMs() {
        return this.maxCacheDurationMs;
    }

    public long getExpirationTime() {
        return this.storageAccessConfig.expiresAt().map(Instant::toEpochMilli).orElse(Long.MAX_VALUE);
    }

    StorageAccessConfig toAccessConfig() {
        return this.storageAccessConfig;
    }
}

