/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.alerter;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.hertzbeat.common.entity.manager.JsonStringListAttributeConverter;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_alert_group_converge")
@Schema(description="Alert Group Converge Policy Entity")
@EntityListeners(value={AuditingEntityListener.class})
public class AlertGroupConverge {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="Primary Key Index ID", example="87584674384")
    private Long id;
    @Schema(title="Policy name", example="group-converge-1")
    @Size(max=100)
    @NotNull
    private @Size(max=100) @NotNull String name;
    @Schema(title="Labels to group by", example="[\"instance\"]")
    @Convert(converter=JsonStringListAttributeConverter.class)
    @Column(name="group_labels", length=1024)
    private List<String> groupLabels;
    @Schema(title="Initial wait time before sending first group alert (s)", example="30")
    @Column(name="group_wait")
    private Long groupWait;
    @Schema(title="Interval between group alert sends (s)", example="300")
    @Column(name="group_interval")
    private Long groupInterval;
    @Schema(title="Interval for repeating firing alerts (s), set to 0 to disable repeating", example="9000")
    @Column(name="repeat_interval")
    private Long repeatInterval;
    @Schema(title="Whether to enable this policy", example="true")
    private Boolean enable;
    @Schema(title="The creator of this record", example="tom")
    @CreatedBy
    private String creator;
    @Schema(title="This record was last modified by", example="tom")
    @LastModifiedBy
    private String modifier;
    @Schema(title="This record creation time (millisecond timestamp)")
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record the latest modification time (timestamp in milliseconds)")
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public static AlertGroupConvergeBuilder builder() {
        return new AlertGroupConvergeBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getGroupLabels() {
        return this.groupLabels;
    }

    public Long getGroupWait() {
        return this.groupWait;
    }

    public Long getGroupInterval() {
        return this.groupInterval;
    }

    public Long getRepeatInterval() {
        return this.repeatInterval;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setGroupLabels(List<String> groupLabels) {
        this.groupLabels = groupLabels;
    }

    public void setGroupWait(Long groupWait) {
        this.groupWait = groupWait;
    }

    public void setGroupInterval(Long groupInterval) {
        this.groupInterval = groupInterval;
    }

    public void setRepeatInterval(Long repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlertGroupConverge)) {
            return false;
        }
        AlertGroupConverge other = (AlertGroupConverge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$groupWait = this.getGroupWait();
        Long other$groupWait = other.getGroupWait();
        if (this$groupWait == null ? other$groupWait != null : !((Object)this$groupWait).equals(other$groupWait)) {
            return false;
        }
        Long this$groupInterval = this.getGroupInterval();
        Long other$groupInterval = other.getGroupInterval();
        if (this$groupInterval == null ? other$groupInterval != null : !((Object)this$groupInterval).equals(other$groupInterval)) {
            return false;
        }
        Long this$repeatInterval = this.getRepeatInterval();
        Long other$repeatInterval = other.getRepeatInterval();
        if (this$repeatInterval == null ? other$repeatInterval != null : !((Object)this$repeatInterval).equals(other$repeatInterval)) {
            return false;
        }
        Boolean this$enable = this.getEnable();
        Boolean other$enable = other.getEnable();
        if (this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$groupLabels = this.getGroupLabels();
        List<String> other$groupLabels = other.getGroupLabels();
        if (this$groupLabels == null ? other$groupLabels != null : !((Object)this$groupLabels).equals(other$groupLabels)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        return !(this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlertGroupConverge;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $groupWait = this.getGroupWait();
        result = result * 59 + ($groupWait == null ? 43 : ((Object)$groupWait).hashCode());
        Long $groupInterval = this.getGroupInterval();
        result = result * 59 + ($groupInterval == null ? 43 : ((Object)$groupInterval).hashCode());
        Long $repeatInterval = this.getRepeatInterval();
        result = result * 59 + ($repeatInterval == null ? 43 : ((Object)$repeatInterval).hashCode());
        Boolean $enable = this.getEnable();
        result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $groupLabels = this.getGroupLabels();
        result = result * 59 + ($groupLabels == null ? 43 : ((Object)$groupLabels).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        return result;
    }

    public String toString() {
        return "AlertGroupConverge(id=" + this.getId() + ", name=" + this.getName() + ", groupLabels=" + this.getGroupLabels() + ", groupWait=" + this.getGroupWait() + ", groupInterval=" + this.getGroupInterval() + ", repeatInterval=" + this.getRepeatInterval() + ", enable=" + this.getEnable() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public AlertGroupConverge(Long id, String name, List<String> groupLabels, Long groupWait, Long groupInterval, Long repeatInterval, Boolean enable, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.name = name;
        this.groupLabels = groupLabels;
        this.groupWait = groupWait;
        this.groupInterval = groupInterval;
        this.repeatInterval = repeatInterval;
        this.enable = enable;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public AlertGroupConverge() {
    }

    public static class AlertGroupConvergeBuilder {
        private Long id;
        private String name;
        private List<String> groupLabels;
        private Long groupWait;
        private Long groupInterval;
        private Long repeatInterval;
        private Boolean enable;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        AlertGroupConvergeBuilder() {
        }

        public AlertGroupConvergeBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public AlertGroupConvergeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AlertGroupConvergeBuilder groupLabels(List<String> groupLabels) {
            this.groupLabels = groupLabels;
            return this;
        }

        public AlertGroupConvergeBuilder groupWait(Long groupWait) {
            this.groupWait = groupWait;
            return this;
        }

        public AlertGroupConvergeBuilder groupInterval(Long groupInterval) {
            this.groupInterval = groupInterval;
            return this;
        }

        public AlertGroupConvergeBuilder repeatInterval(Long repeatInterval) {
            this.repeatInterval = repeatInterval;
            return this;
        }

        public AlertGroupConvergeBuilder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public AlertGroupConvergeBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public AlertGroupConvergeBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public AlertGroupConvergeBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public AlertGroupConvergeBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public AlertGroupConverge build() {
            return new AlertGroupConverge(this.id, this.name, this.groupLabels, this.groupWait, this.groupInterval, this.repeatInterval, this.enable, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "AlertGroupConverge.AlertGroupConvergeBuilder(id=" + this.id + ", name=" + this.name + ", groupLabels=" + this.groupLabels + ", groupWait=" + this.groupWait + ", groupInterval=" + this.groupInterval + ", repeatInterval=" + this.repeatInterval + ", enable=" + this.enable + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

