/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.rpc.limit;

import com.netflix.concurrency.limits.MetricRegistry;
import com.netflix.concurrency.limits.internal.EmptyMetricRegistry;
import com.netflix.concurrency.limits.limit.AbstractLimit;
import com.netflix.concurrency.limits.limit.functions.Log10RootFunction;
import io.greptime.common.util.Ensures;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VegasLimit
extends AbstractLimit {
    private static final Logger LOG = LoggerFactory.getLogger(VegasLimit.class);
    private static final Function<Integer, Integer> LOG10 = Log10RootFunction.create((int)0);
    private volatile double estimatedLimit;
    private volatile long rtt_noload = 0L;
    private final int maxLimit;
    private final double smoothing;
    private final Function<Integer, Integer> alphaFunc;
    private final Function<Integer, Integer> betaFunc;
    private final Function<Integer, Integer> thresholdFunc;
    private final Function<Double, Double> increaseFunc;
    private final Function<Double, Double> decreaseFunc;
    private final MetricRegistry.SampleListener rttSampleListener;
    private final int probeMultiplier;
    private final boolean logOnLimitChange;
    private int probeCount = 0;
    private double probeJitter;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static VegasLimit newDefault() {
        return VegasLimit.newBuilder().build();
    }

    private VegasLimit(Builder builder) {
        super(builder.initialLimit);
        this.estimatedLimit = builder.initialLimit;
        this.maxLimit = builder.maxConcurrency;
        this.alphaFunc = builder.alphaFunc;
        this.betaFunc = builder.betaFunc;
        this.increaseFunc = builder.increaseFunc;
        this.decreaseFunc = builder.decreaseFunc;
        this.thresholdFunc = builder.thresholdFunc;
        this.smoothing = builder.smoothing;
        this.probeMultiplier = builder.probeMultiplier;
        this.logOnLimitChange = builder.logOnLimitChange;
        this.resetProbeJitter();
        this.rttSampleListener = builder.registry.distribution("min_rtt", new String[0]);
    }

    private void resetProbeJitter() {
        this.probeJitter = ThreadLocalRandom.current().nextDouble(0.5, 1.0);
    }

    private boolean shouldProbe() {
        return this.probeJitter * (double)this.probeMultiplier * this.estimatedLimit <= (double)this.probeCount;
    }

    protected int _update(long startTime, long rtt, int inflight, boolean didDrop) {
        Ensures.ensure((rtt > 0L ? 1 : 0) != 0, (Object)("rtt must be > 0 but got " + rtt));
        ++this.probeCount;
        if (this.shouldProbe()) {
            LOG.debug("Probe MinRTT {}.", (Object)((double)TimeUnit.NANOSECONDS.toMicros(rtt) / 1000.0));
            this.resetProbeJitter();
            this.probeCount = 0;
            this.rtt_noload = rtt;
            return (int)this.estimatedLimit;
        }
        if (this.rtt_noload == 0L || rtt < this.rtt_noload) {
            LOG.debug("New MinRTT {}.", (Object)((double)TimeUnit.NANOSECONDS.toMicros(rtt) / 1000.0));
            this.rtt_noload = rtt;
            return (int)this.estimatedLimit;
        }
        this.rttSampleListener.addSample((Number)this.getRttMillis(this.rtt_noload));
        return this.updateEstimatedLimit(rtt, inflight, didDrop);
    }

    private int updateEstimatedLimit(long rtt, int inflight, boolean didDrop) {
        double newLimit;
        double currLimit = this.estimatedLimit;
        int queueSize = (int)Math.ceil(currLimit * (1.0 - (double)this.rtt_noload / (double)rtt));
        if (didDrop) {
            newLimit = this.decreaseFunc.apply(currLimit);
        } else {
            if ((double)(inflight * 2) < currLimit) {
                return (int)currLimit;
            }
            int alpha = this.alphaFunc.apply((int)currLimit);
            int beta = this.betaFunc.apply((int)currLimit);
            int threshold = this.thresholdFunc.apply((int)currLimit);
            if (queueSize <= threshold) {
                newLimit = currLimit + (double)beta;
            } else if (queueSize < alpha) {
                newLimit = this.increaseFunc.apply(currLimit);
            } else if (queueSize > beta) {
                newLimit = this.decreaseFunc.apply(currLimit);
            } else {
                return (int)currLimit;
            }
        }
        newLimit = Math.max(1.0, Math.min((double)this.maxLimit, newLimit));
        newLimit = (1.0 - this.smoothing) * currLimit + this.smoothing * newLimit;
        if (this.logOnLimitChange && (int)newLimit != (int)currLimit) {
            LOG.info("New limit={}, previous limit={}, minRtt={} ms, winRtt={} ms, queueSize={}.", new Object[]{(int)newLimit, (int)currLimit, (double)TimeUnit.NANOSECONDS.toMicros(this.rtt_noload) / 1000.0, (double)TimeUnit.NANOSECONDS.toMicros(rtt) / 1000.0, queueSize});
        }
        this.estimatedLimit = newLimit;
        return (int)this.estimatedLimit;
    }

    private long getRttMillis(long nanos) {
        return TimeUnit.NANOSECONDS.toMillis(nanos);
    }

    public String toString() {
        return "VegasLimit [limit=" + this.getLimit() + ", rtt_noload=" + (double)TimeUnit.NANOSECONDS.toMicros(this.rtt_noload) / 1000.0 + " ms]";
    }

    public static class Builder {
        private int initialLimit = 20;
        private int maxConcurrency = 1000;
        private MetricRegistry registry = EmptyMetricRegistry.INSTANCE;
        private double smoothing = 1.0;
        private Function<Integer, Integer> alphaFunc = limit -> 3 * (Integer)LOG10.apply(limit);
        private Function<Integer, Integer> betaFunc = limit -> 6 * (Integer)LOG10.apply(limit);
        private Function<Integer, Integer> thresholdFunc = VegasLimit.access$000();
        private Function<Double, Double> increaseFunc = limit -> limit + (double)((Integer)LOG10.apply(limit.intValue())).intValue();
        private Function<Double, Double> decreaseFunc = limit -> limit - (double)((Integer)LOG10.apply(limit.intValue())).intValue();
        private int probeMultiplier = 30;
        private boolean logOnLimitChange = true;

        private Builder() {
        }

        public Builder probeMultiplier(int probeMultiplier) {
            this.probeMultiplier = probeMultiplier;
            return this;
        }

        public Builder alpha(int alpha) {
            this.alphaFunc = ignore -> alpha;
            return this;
        }

        public Builder threshold(Function<Integer, Integer> threshold) {
            this.thresholdFunc = threshold;
            return this;
        }

        public Builder alpha(Function<Integer, Integer> alpha) {
            this.alphaFunc = alpha;
            return this;
        }

        public Builder beta(int beta) {
            this.betaFunc = ignore -> beta;
            return this;
        }

        public Builder beta(Function<Integer, Integer> beta) {
            this.betaFunc = beta;
            return this;
        }

        public Builder increase(Function<Double, Double> increase) {
            this.increaseFunc = increase;
            return this;
        }

        public Builder decrease(Function<Double, Double> decrease) {
            this.decreaseFunc = decrease;
            return this;
        }

        public Builder smoothing(double smoothing) {
            this.smoothing = smoothing;
            return this;
        }

        public Builder initialLimit(int initialLimit) {
            this.initialLimit = initialLimit;
            return this;
        }

        public Builder maxConcurrency(int maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public Builder logOnLimitChange(boolean logOnLimitChange) {
            this.logOnLimitChange = logOnLimitChange;
            return this;
        }

        public Builder metricRegistry(MetricRegistry registry) {
            this.registry = registry;
            return this;
        }

        public VegasLimit build() {
            return new VegasLimit(this);
        }
    }
}

