/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.common.signal;

import io.greptime.common.util.Files;
import io.greptime.common.util.SystemPropertyUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class FileOutputHelper {
    private static final String OUT_DIR = SystemPropertyUtil.get("greptimedb.signal.out_dir", "");

    public static File getOutputFile(String baseFileName) throws IOException {
        Files.mkdirIfNotExists(OUT_DIR);
        String now = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        String fileName = baseFileName + "." + now;
        File file = Paths.get(OUT_DIR, fileName).toFile();
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Fail to create file: " + file);
        }
        return file;
    }

    public static String getOutDir() {
        return Paths.get(OUT_DIR, new String[0]).toAbsolutePath().toString();
    }

    private FileOutputHelper() {
    }
}

