/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.subject.creater;

import com.usthe.sureness.subject.PrincipalMap;
import com.usthe.sureness.subject.Subject;
import com.usthe.sureness.subject.SubjectCreate;
import com.usthe.sureness.subject.support.SessionSubject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.List;

public class SessionSubjectJakartaServletCreator
implements SubjectCreate {
    @Override
    public boolean canSupportSubject(Object context) {
        if (context instanceof HttpServletRequest) {
            HttpSession httpSession = ((HttpServletRequest)context).getSession(false);
            return httpSession != null && httpSession.getAttribute("principal") != null;
        }
        return false;
    }

    @Override
    public Subject createSubject(Object context) {
        HttpServletRequest servletRequest = (HttpServletRequest)context;
        HttpSession httpSession = servletRequest.getSession(false);
        String principal = (String)httpSession.getAttribute("principal");
        if (principal == null || "".equals(principal.trim())) {
            return null;
        }
        Object principalMapTmp = httpSession.getAttribute("principals");
        PrincipalMap principalMap = principalMapTmp == null ? null : (PrincipalMap)principalMapTmp;
        Object rolesTmp = httpSession.getAttribute("roles");
        List roles = rolesTmp == null ? null : (List)rolesTmp;
        String remoteHost = ((HttpServletRequest)context).getRemoteHost();
        String requestUri = ((HttpServletRequest)context).getRequestURI();
        String requestType = ((HttpServletRequest)context).getMethod();
        String targetUri = requestUri.concat("===").concat(requestType).toLowerCase();
        return SessionSubject.builder(principal, roles).setPrincipalMap(principalMap).setRemoteHost(remoteHost).setTargetResource(targetUri).build();
    }
}

