/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.bit.io;

import com.github.jinahya.bit.io.AbstractByteInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ArrayByteInput
extends AbstractByteInput<byte[]> {
    int index;

    public static ArrayByteInput of(final int length, final InputStream stream) {
        if (length <= 0) {
            throw new IllegalArgumentException("length(" + length + ") <= 0");
        }
        if (stream == null) {
            throw new NullPointerException("stream is null");
        }
        return new ArrayByteInput(null){

            @Override
            public int read() throws IOException {
                if (this.source == null) {
                    this.source = new byte[length];
                    this.index = ((byte[])this.source).length;
                }
                if (this.index == ((byte[])this.source).length) {
                    int read = stream.read((byte[])this.source);
                    if (read == -1) {
                        throw new EOFException();
                    }
                    assert (read > 0);
                    this.index = 0;
                }
                return super.read();
            }

            @Override
            public void setSource(byte[] source) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setIndex(int index) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public ArrayByteInput(byte[] source) {
        super(source);
        this.index = source == null || source.length == 0 ? -1 : 0;
    }

    @Override
    public int read() throws IOException {
        return ((byte[])this.source)[this.index++] & 0xFF;
    }

    public ArrayByteInput source(byte[] target) {
        return (ArrayByteInput)super.source(target);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public ArrayByteInput index(int index) {
        this.setIndex(index);
        return this;
    }
}

