/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store.history.influxdb;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.apache.hertzbeat.common.entity.arrow.ArrowCell;
import org.apache.hertzbeat.common.entity.arrow.RowWrapper;
import org.apache.hertzbeat.common.entity.dto.Value;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.warehouse.store.history.AbstractHistoryDataStorage;
import org.apache.hertzbeat.warehouse.store.history.influxdb.InfluxdbProperties;
import org.apache.http.ssl.SSLContexts;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="warehouse.store.influxdb", name={"enabled"}, havingValue="true")
public class InfluxdbDataStorage
extends AbstractHistoryDataStorage {
    private static final Logger log = LoggerFactory.getLogger(InfluxdbDataStorage.class);
    private static final String DATABASE = "hertzbeat";
    private static final String SHOW_DATABASE = "SHOW DATABASES";
    private static final String CREATE_DATABASE = "CREATE DATABASE %s";
    private static final String QUERY_HISTORY_SQL = "SELECT instance, %s FROM %s WHERE time >= now() - %s order by time desc";
    private static final String QUERY_HISTORY_SQL_WITH_INSTANCE = "SELECT instance, %s FROM %s WHERE instance = '%s' and time >= now() - %s order by time desc";
    private static final String QUERY_HISTORY_INTERVAL_WITH_INSTANCE_SQL = "SELECT FIRST(%s), MEAN(%s), MAX(%s), MIN(%s) FROM %s WHERE instance = '%s' and time >= now() - %s GROUP BY time(4h)";
    private static final String CREATE_RETENTION_POLICY = "CREATE RETENTION POLICY \"%s_retention\" ON \"%s\" DURATION %s REPLICATION %d DEFAULT";
    private static final String QUERY_INSTANCE_SQL = "show tag values from %s with key = \"instance\"";
    private InfluxDB influxDb;

    public InfluxdbDataStorage(InfluxdbProperties influxdbProperties) {
        this.initInfluxDb(influxdbProperties);
    }

    public void initInfluxDb(InfluxdbProperties influxdbProperties) {
        OkHttpClient.Builder client = new OkHttpClient.Builder().readTimeout(6000L, TimeUnit.SECONDS).writeTimeout(6000L, TimeUnit.SECONDS).connectTimeout(6000L, TimeUnit.SECONDS).connectionPool(new ConnectionPool(20, 30000L, TimeUnit.SECONDS)).sslSocketFactory(InfluxdbDataStorage.defaultSslSocketFactory(), InfluxdbDataStorage.defaultTrustManager()).hostnameVerifier(InfluxdbDataStorage.noopHostnameVerifier()).retryOnConnectionFailure(true);
        this.influxDb = InfluxDBFactory.connect((String)influxdbProperties.serverUrl(), (String)influxdbProperties.username(), (String)influxdbProperties.password(), (OkHttpClient.Builder)client);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((InfluxDB)this.influxDb).close()));
        this.serverAvailable = this.createDatabase(influxdbProperties);
    }

    private boolean createDatabase(InfluxdbProperties influxdbProperties) {
        QueryResult queryResult = this.influxDb.query(new Query(SHOW_DATABASE));
        if (queryResult.hasError()) {
            log.error("show databases in influxdb error, msg: {}", (Object)queryResult.getError());
            return false;
        }
        for (QueryResult.Result result : queryResult.getResults()) {
            for (QueryResult.Series series : result.getSeries()) {
                for (List values : series.getValues()) {
                    if (!values.contains(DATABASE)) continue;
                    return true;
                }
            }
        }
        String createDatabaseSql = String.format(CREATE_DATABASE, DATABASE);
        QueryResult createDatabaseResult = this.influxDb.query(new Query(createDatabaseSql));
        if (createDatabaseResult.hasError()) {
            log.error("create database {} in influxdb error, msg: {}", (Object)DATABASE, (Object)createDatabaseResult.getError());
            return false;
        }
        String createRetentionPolicySql = String.format(CREATE_RETENTION_POLICY, DATABASE, DATABASE, influxdbProperties.expireTime(), influxdbProperties.replication());
        QueryResult createRetentionPolicySqlResult = this.influxDb.query(new Query(createRetentionPolicySql));
        if (createRetentionPolicySqlResult.hasError()) {
            log.error("create retention policy in influxdb error, msg: {}", (Object)createDatabaseResult.getError());
            return false;
        }
        return true;
    }

    @Override
    public void saveData(CollectRep.MetricsData metricsData) {
        if (!this.isServerAvailable() || metricsData.getCode() != CollectRep.Code.SUCCESS) {
            return;
        }
        if (metricsData.getValues().isEmpty()) {
            log.info("[warehouse influxdb] flush metrics data {} is null, ignore.", (Object)metricsData.getId());
            return;
        }
        String table = this.generateTable(metricsData.getApp(), metricsData.getMetrics(), metricsData.getId());
        ArrayList<Point> points = new ArrayList<Point>();
        try {
            BatchPoints.Builder builder;
            RowWrapper rowWrapper = metricsData.readRow();
            while (rowWrapper.hasNextRow()) {
                rowWrapper = rowWrapper.nextRow();
                builder = Point.measurement((String)table);
                builder.time(metricsData.getTime(), TimeUnit.MILLISECONDS);
                HashMap labels = Maps.newHashMapWithExpectedSize((int)8);
                rowWrapper.cellStream().forEach(arg_0 -> InfluxdbDataStorage.lambda$saveData$0((Point.Builder)builder, labels, arg_0));
                builder.tag("instance", JsonUtil.toJson((Object)labels));
                points.add(builder.build());
            }
            builder = BatchPoints.database((String)DATABASE);
            builder.points(points);
            this.influxDb.write(builder.build());
        }
        catch (Exception e) {
            log.error("[warehouse influxdb]--Error: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public Map<String, List<Value>> getHistoryMetricData(Long monitorId, String app, String metrics, String metric, String label, String history) {
        String table = this.generateTable(app, metrics, monitorId);
        String selectSql = label == null ? String.format(QUERY_HISTORY_SQL, metric, table, history) : String.format(QUERY_HISTORY_SQL_WITH_INSTANCE, metric, table, label, history);
        HashMap<String, List<Value>> instanceValueMap = new HashMap<String, List<Value>>(8);
        try {
            QueryResult selectResult = this.influxDb.query(new Query(selectSql, DATABASE), TimeUnit.MILLISECONDS);
            for (QueryResult.Result result : selectResult.getResults()) {
                if (result.getSeries() == null) continue;
                for (QueryResult.Series series : result.getSeries()) {
                    for (List value : series.getValues()) {
                        String strValue;
                        long time = this.parseTimeToMillis(value.get(0));
                        String instanceValue = value.get(1) == null ? "" : String.valueOf(value.get(1));
                        String string = strValue = value.get(2) == null ? null : this.parseDoubleValue(value.get(2).toString());
                        if (strValue == null) continue;
                        List valueList = instanceValueMap.computeIfAbsent(instanceValue, k -> new LinkedList());
                        valueList.add(new Value(strValue, time));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("select history metric data in influxdb error, sql:{}, msg: {}", (Object)selectSql, (Object)e.getMessage());
        }
        return instanceValueMap;
    }

    @Override
    public Map<String, List<Value>> getHistoryIntervalMetricData(Long monitorId, String app, String metrics, String metric, String label, String history) {
        String table = this.generateTable(app, metrics, monitorId);
        HashMap<String, List<Value>> instanceValueMap = new HashMap<String, List<Value>>(8);
        HashSet<String> instances = new HashSet<String>(8);
        if (label != null) {
            instances.add(label);
        }
        if (instances.isEmpty()) {
            String queryInstanceSql = String.format(QUERY_INSTANCE_SQL, table);
            QueryResult instanceQueryResult = this.influxDb.query(new Query(queryInstanceSql, DATABASE), TimeUnit.MILLISECONDS);
            for (QueryResult.Result result : instanceQueryResult.getResults()) {
                if (result.getSeries() == null) continue;
                for (QueryResult.Series series : result.getSeries()) {
                    for (List value : series.getValues()) {
                        if (value == null || value.get(1) == null) continue;
                        instances.add(value.get(1).toString());
                    }
                }
            }
        }
        try {
            history = history.toLowerCase();
            if (instances.isEmpty()) {
                instances.add("");
            }
            for (String instanceValue : instances) {
                String selectSql = String.format(QUERY_HISTORY_INTERVAL_WITH_INSTANCE_SQL, metric, metric, metric, metric, table, instanceValue, history);
                QueryResult selectResult = this.influxDb.query(new Query(selectSql, DATABASE), TimeUnit.MILLISECONDS);
                for (QueryResult.Result result : selectResult.getResults()) {
                    if (result.getSeries() == null) continue;
                    for (QueryResult.Series series : result.getSeries()) {
                        for (List value : series.getValues()) {
                            Value.ValueBuilder valueBuilder = Value.builder();
                            long time = this.parseTimeToMillis(value.get(0));
                            valueBuilder.time(Long.valueOf(time));
                            if (value.get(1) == null) continue;
                            valueBuilder.origin(this.parseDoubleValue(value.get(1).toString()));
                            if (value.get(2) == null) continue;
                            valueBuilder.mean(this.parseDoubleValue(value.get(2).toString()));
                            if (value.get(3) == null) continue;
                            valueBuilder.max(this.parseDoubleValue(value.get(3).toString()));
                            if (value.get(4) == null) continue;
                            valueBuilder.min(this.parseDoubleValue(value.get(4).toString()));
                            List valueList = instanceValueMap.computeIfAbsent(instanceValue, k -> new LinkedList());
                            valueList.add(valueBuilder.build());
                        }
                    }
                }
                List instanceValueList = (List)instanceValueMap.get(instanceValue);
                if (instanceValueList != null && !instanceValueList.isEmpty()) continue;
                instanceValueMap.remove(instanceValue);
            }
        }
        catch (Exception e) {
            log.error("select history interval metric data in influxdb error, msg: {}", (Object)e.getMessage());
        }
        return instanceValueMap;
    }

    private String generateTable(String app, String metrics, Long monitorId) {
        return app + "_" + metrics + "_" + monitorId;
    }

    private long parseTimeToMillis(Object time) {
        if (time == null) {
            return 0L;
        }
        Double doubleTime = (Double)time;
        return doubleTime.longValue();
    }

    private String parseDoubleValue(String value) {
        return new BigDecimal(value).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
    }

    private static X509TrustManager defaultTrustManager() {
        return new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        };
    }

    private static SSLSocketFactory defaultSslSocketFactory() {
        try {
            SSLContext sslContext = SSLContexts.createDefault();
            sslContext.init(null, new TrustManager[]{InfluxdbDataStorage.defaultTrustManager()}, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static HostnameVerifier noopHostnameVerifier() {
        return (s, sslSession) -> true;
    }

    public void destroy() throws Exception {
        if (this.influxDb != null) {
            this.influxDb.close();
        }
    }

    private static /* synthetic */ void lambda$saveData$0(Point.Builder builder, Map labels, ArrowCell cell) {
        if ("&nbsp;".equals(cell.getValue())) {
            builder.addField(cell.getField().getName(), "");
            return;
        }
        Byte type = cell.getMetadataAsByte("type");
        if (type == 0) {
            builder.addField(cell.getField().getName(), Double.parseDouble(cell.getValue()));
        } else if (type == 1) {
            builder.addField(cell.getField().getName(), cell.getValue());
        }
        if (cell.getMetadataAsBoolean("label").booleanValue()) {
            labels.put(cell.getField().getName(), cell.getValue());
        }
    }
}

