/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.web.v3_1;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.incubator.builder.internal.DefaultHttpClientInstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.spring.web.v3_1.HttpRequestSetter;
import io.opentelemetry.instrumentation.spring.web.v3_1.SpringWebHttpAttributesGetter;
import io.opentelemetry.instrumentation.spring.web.v3_1.SpringWebTelemetry;
import io.opentelemetry.instrumentation.spring.web.v3_1.internal.Experimental;
import io.opentelemetry.instrumentation.spring.web.v3_1.internal.WebTelemetryUtil;
import java.util.Collection;
import java.util.function.Function;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public final class SpringWebTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-web-3.1";
    private final DefaultHttpClientInstrumenterBuilder<HttpRequest, ClientHttpResponse> builder;

    SpringWebTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.builder = DefaultHttpClientInstrumenterBuilder.create((String)INSTRUMENTATION_NAME, (OpenTelemetry)openTelemetry, (HttpClientAttributesGetter)SpringWebHttpAttributesGetter.INSTANCE, (TextMapSetter)HttpRequestSetter.INSTANCE);
    }

    private DefaultHttpClientInstrumenterBuilder<HttpRequest, ClientHttpResponse> getBuilder() {
        return this.builder;
    }

    @CanIgnoreReturnValue
    public SpringWebTelemetryBuilder addAttributesExtractor(AttributesExtractor<HttpRequest, ClientHttpResponse> attributesExtractor) {
        this.builder.addAttributesExtractor(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebTelemetryBuilder setCapturedRequestHeaders(Collection<String> requestHeaders) {
        this.builder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebTelemetryBuilder setCapturedResponseHeaders(Collection<String> responseHeaders) {
        this.builder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebTelemetryBuilder setSpanNameExtractor(Function<SpanNameExtractor<HttpRequest>, SpanNameExtractor<HttpRequest>> spanNameExtractorTransformer) {
        this.builder.setSpanNameExtractor(spanNameExtractorTransformer);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebTelemetryBuilder setKnownMethods(Collection<String> knownMethods) {
        this.builder.setKnownMethods(knownMethods);
        return this;
    }

    public SpringWebTelemetry build() {
        return new SpringWebTelemetry((Instrumenter<HttpRequest, ClientHttpResponse>)this.builder.build());
    }

    static {
        WebTelemetryUtil.setBuilderExtractor(SpringWebTelemetryBuilder::getBuilder);
        Experimental.internalSetEmitExperimentalTelemetry((builder, emit) -> builder.builder.setEmitExperimentalHttpClientTelemetry(emit.booleanValue()));
    }
}

