/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.validation.Valid;
import java.util.List;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.common.entity.manager.Bulletin;
import org.apache.hertzbeat.common.util.ResponseUtil;
import org.apache.hertzbeat.manager.pojo.dto.BulletinMetricsData;
import org.apache.hertzbeat.manager.service.BulletinService;
import org.apache.hertzbeat.warehouse.store.realtime.RealTimeDataReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/bulletin"}, produces={"application/json"})
public class BulletinController {
    private static final Logger log = LoggerFactory.getLogger(BulletinController.class);
    @Autowired
    private BulletinService bulletinService;
    @Autowired
    private RealTimeDataReader realTimeDataReader;

    @Operation(summary="New a bulletin", description="Add new bulletin")
    @PostMapping
    public ResponseEntity<Message<Void>> addNewBulletin(@Valid @RequestBody Bulletin bulletin) {
        try {
            this.bulletinService.validate(bulletin);
            this.bulletinService.addBulletin(bulletin);
        }
        catch (Exception e) {
            return ResponseEntity.ok(Message.fail((byte)15, "Add failed! " + e.getMessage()));
        }
        return ResponseEntity.ok(Message.success("Add success!"));
    }

    @Operation(summary="Update a bulletin", description="Update the bulletin")
    @PutMapping
    public ResponseEntity<Message<Void>> editBulletin(@Valid @RequestBody Bulletin bulletin) {
        try {
            this.bulletinService.validate(bulletin);
            this.bulletinService.editBulletin(bulletin);
        }
        catch (Exception e) {
            return ResponseEntity.ok(Message.fail((byte)15, "Edit failed! " + e.getMessage()));
        }
        return ResponseEntity.ok(Message.success("Add success!"));
    }

    @Operation(summary="Query One Bulletin", description="Query One Bulletin")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<Message<Bulletin>> getBulletin(@Valid @PathVariable Long id) {
        return ResponseEntity.ok(Message.success(this.bulletinService.getBulletinById(id).orElse(null)));
    }

    @Operation(summary="Query Bulletins", description="Query All Bulletin")
    @GetMapping
    public ResponseEntity<Message<Page<Bulletin>>> queryBulletins(@Parameter(description="Search", example="tom") @RequestParam(required=false) String search, @Parameter(description="List current page", example="0") @RequestParam(defaultValue="0") Integer pageIndex, @Parameter(description="Number of list pagination", example="8") @RequestParam(required=false) Integer pageSize) {
        return ResponseUtil.handle(() -> this.bulletinService.getBulletins(search, pageIndex, pageSize));
    }

    @Operation(summary="Delete Bulletins", description="Delete Bulletin by ids")
    @DeleteMapping
    public ResponseEntity<Message<Void>> deleteBulletin(@Parameter(description="Bulletin ids") @RequestParam List<Long> ids) {
        this.bulletinService.deleteBulletins(ids);
        return ResponseEntity.ok(Message.success("Delete success!"));
    }

    @GetMapping(value={"/metrics"})
    @Operation(summary="Query All Bulletin Real Time Metrics Data", description="Query All Bulletin real-time metrics data of monitoring indicators")
    public ResponseEntity<Message<?>> getAllMetricsData(@RequestParam(name="id") Long id) {
        if (!this.realTimeDataReader.isServerAvailable()) {
            return ResponseEntity.ok(Message.fail((byte)15, "real time store not available"));
        }
        BulletinMetricsData data = this.bulletinService.buildBulletinMetricsData(id);
        return ResponseEntity.ok(Message.success(data));
    }
}

