/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.usthe.sureness.util.JsonWebTokenUtil;
import jakarta.annotation.Resource;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.base.dao.GeneralConfigDao;
import org.apache.hertzbeat.common.entity.manager.GeneralConfig;
import org.apache.hertzbeat.common.util.TimeZoneUtil;
import org.apache.hertzbeat.manager.pojo.dto.MuteConfig;
import org.apache.hertzbeat.manager.pojo.dto.SystemConfig;
import org.apache.hertzbeat.manager.pojo.dto.SystemSecret;
import org.apache.hertzbeat.manager.pojo.dto.TemplateConfig;
import org.apache.hertzbeat.manager.service.AppService;
import org.apache.hertzbeat.manager.service.impl.MuteGeneralConfigServiceImpl;
import org.apache.hertzbeat.manager.service.impl.SystemGeneralConfigServiceImpl;
import org.apache.hertzbeat.manager.service.impl.SystemSecretServiceImpl;
import org.apache.hertzbeat.manager.service.impl.TemplateConfigServiceImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483646)
public class ConfigInitializer
implements SmartLifecycle {
    private boolean running = false;
    private static final String DEFAULT_JWT_SECRET = "CyaFv0bwq2Eik0jdrKUtsA6bx3sDJeFV643R LnfKefTjsIfJLBa2YkhEqEGtcHDTNe4CU6+9 8tVt4bisXQ13rbN0oxhUZR73M6EByXIO+SV5 dKhaX0csgOCTlCxq20yhmUea6H6JIpSE2Rwp";
    @Value(value="${sureness.jwt.secret:CyaFv0bwq2Eik0jdrKUtsA6bx3sDJeFV643R LnfKefTjsIfJLBa2YkhEqEGtcHDTNe4CU6+9 8tVt4bisXQ13rbN0oxhUZR73M6EByXIO+SV5 dKhaX0csgOCTlCxq20yhmUea6H6JIpSE2Rwp}")
    private String currentJwtSecret;
    @Resource
    private SystemGeneralConfigServiceImpl systemGeneralConfigService;
    @Resource
    private SystemSecretServiceImpl systemSecretService;
    @Resource
    private TemplateConfigServiceImpl templateConfigService;
    @Resource
    private MuteGeneralConfigServiceImpl muteGeneralConfigService;
    @Resource
    private AppService appService;
    @Resource
    protected GeneralConfigDao generalConfigDao;
    @Resource
    protected ObjectMapper objectMapper;

    public void initConfig() {
        SystemConfig systemConfig = (SystemConfig)this.systemGeneralConfigService.getConfig();
        if (systemConfig != null) {
            TimeZoneUtil.setTimeZoneAndLocale(systemConfig.getTimeZoneId(), systemConfig.getLocale());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
            simpleDateFormat.setTimeZone(TimeZone.getDefault());
            this.objectMapper.setTimeZone(TimeZone.getDefault()).setDateFormat((DateFormat)simpleDateFormat);
        } else {
            systemConfig = SystemConfig.builder().timeZoneId(TimeZone.getDefault().getID()).theme("default").locale(Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry()).build();
            String contentJson = this.objectMapper.writeValueAsString((Object)systemConfig);
            GeneralConfig generalConfig2Save = GeneralConfig.builder().type(this.systemGeneralConfigService.type()).content(contentJson).build();
            this.generalConfigDao.save((Object)generalConfig2Save);
        }
        TemplateConfig templateConfig = (TemplateConfig)this.templateConfigService.getConfig();
        this.appService.updateCustomTemplateConfig(templateConfig);
        if (DEFAULT_JWT_SECRET.equals(this.currentJwtSecret)) {
            SystemSecret systemSecret = (SystemSecret)this.systemSecretService.getConfig();
            if (systemSecret == null || StringUtils.isBlank((CharSequence)systemSecret.getJwtSecret())) {
                char[] chars = DEFAULT_JWT_SECRET.toCharArray();
                Random rand = new Random();
                for (int i = 0; i < chars.length; ++i) {
                    int index = rand.nextInt(chars.length);
                    char temp = chars[i];
                    chars[i] = chars[index];
                    chars[index] = temp;
                }
                this.currentJwtSecret = new String(chars);
                systemSecret = SystemSecret.builder().jwtSecret(this.currentJwtSecret).build();
                this.systemSecretService.saveConfig(systemSecret);
            } else {
                this.currentJwtSecret = systemSecret.getJwtSecret();
            }
        }
        JsonWebTokenUtil.setDefaultSecretKey((String)this.currentJwtSecret);
        MuteConfig muteConfig = (MuteConfig)this.muteGeneralConfigService.getConfig();
        if (muteConfig == null) {
            muteConfig = MuteConfig.builder().mute(true).build();
            this.muteGeneralConfigService.saveConfig(muteConfig);
        }
    }

    public void start() {
        this.initConfig();
        this.running = true;
    }

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return Integer.MIN_VALUE;
    }
}

