/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal;

import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaConsumerContext;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaProcessRequest;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.TracingIterator;
import java.util.Iterator;
import java.util.function.BooleanSupplier;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class TracingIterable<K, V>
implements Iterable<ConsumerRecord<K, V>> {
    private final Iterable<ConsumerRecord<K, V>> delegate;
    private final Instrumenter<KafkaProcessRequest, Void> instrumenter;
    private final BooleanSupplier wrappingEnabled;
    private final KafkaConsumerContext consumerContext;
    private boolean firstIterator = true;

    protected TracingIterable(Iterable<ConsumerRecord<K, V>> delegate, Instrumenter<KafkaProcessRequest, Void> instrumenter, BooleanSupplier wrappingEnabled, KafkaConsumerContext consumerContext) {
        this.delegate = delegate;
        this.instrumenter = instrumenter;
        this.wrappingEnabled = wrappingEnabled;
        this.consumerContext = consumerContext;
    }

    public static <K, V> Iterable<ConsumerRecord<K, V>> wrap(Iterable<ConsumerRecord<K, V>> delegate, Instrumenter<KafkaProcessRequest, Void> instrumenter, BooleanSupplier wrappingEnabled, KafkaConsumerContext consumerContext) {
        if (wrappingEnabled.getAsBoolean()) {
            return new TracingIterable<K, V>(delegate, instrumenter, wrappingEnabled, consumerContext);
        }
        return delegate;
    }

    @Override
    public Iterator<ConsumerRecord<K, V>> iterator() {
        Iterator<ConsumerRecord<K, V>> it;
        if (this.firstIterator) {
            it = TracingIterator.wrap(this.delegate.iterator(), this.instrumenter, this.wrappingEnabled, this.consumerContext);
            this.firstIterator = false;
        } else {
            it = this.delegate.iterator();
        }
        return it;
    }
}

