/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.trace;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.internal.shaded.AbstractWeakConcurrentMap;
import io.opentelemetry.context.internal.shaded.WeakConcurrentMap;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LeakDetectingSpanProcessor
implements SpanProcessor {
    private static final Logger logger = Logger.getLogger(LeakDetectingSpanProcessor.class.getName());
    private final PendingSpans pendingSpans;

    public static LeakDetectingSpanProcessor create() {
        return new LeakDetectingSpanProcessor((message, throwable) -> logger.log(Level.WARNING, "Span garbage collected before being ended.", (Throwable)throwable));
    }

    LeakDetectingSpanProcessor(BiConsumer<String, Throwable> reporter) {
        this.pendingSpans = PendingSpans.create(reporter);
    }

    public void onStart(Context parentContext, ReadWriteSpan span) {
        CallerStackTrace caller = new CallerStackTrace((ReadableSpan)span);
        StackTraceElement[] stackTrace = caller.getStackTrace();
        caller.setStackTrace(Arrays.copyOfRange(stackTrace, Math.min(3, stackTrace.length), stackTrace.length));
        this.pendingSpans.put(span, caller);
    }

    public boolean isStartRequired() {
        return true;
    }

    public void onEnd(ReadableSpan span) {
        ((CallerStackTrace)this.pendingSpans.remove((Object)span)).ended = true;
    }

    public boolean isEndRequired() {
        return true;
    }

    private static AssertionError callerError(CallerStackTrace caller) {
        AssertionError toThrow = new AssertionError((Object)("Span garbage collected before being ended. Thread: [" + caller.threadName + "] started span : " + caller.spanInformation + " here:"));
        ((Throwable)((Object)toThrow)).setStackTrace(caller.getStackTrace());
        return toThrow;
    }

    private static class CallerStackTrace
    extends Throwable {
        private static final long serialVersionUID = 1234567896L;
        final String threadName = Thread.currentThread().getName();
        final String spanInformation;
        volatile boolean ended;

        CallerStackTrace(ReadableSpan span) {
            super("Thread [" + Thread.currentThread().getName() + "] started span : " + span + " here:");
            this.spanInformation = span.getName() + " [" + span.getSpanContext() + "]";
        }
    }

    private static class PendingSpans
    extends WeakConcurrentMap<ReadableSpan, CallerStackTrace> {
        private final ConcurrentHashMap<AbstractWeakConcurrentMap.WeakKey<ReadableSpan>, CallerStackTrace> map;
        private final BiConsumer<String, Throwable> reporter;

        private static PendingSpans create(BiConsumer<String, Throwable> reporter) {
            PendingSpans pendingSpans = new PendingSpans(new ConcurrentHashMap<AbstractWeakConcurrentMap.WeakKey<ReadableSpan>, CallerStackTrace>(), reporter);
            Thread thread = new Thread((Runnable)((Object)pendingSpans));
            thread.setName("weak-ref-cleaner-leakingspandetector");
            thread.setPriority(1);
            thread.setDaemon(true);
            thread.start();
            return pendingSpans;
        }

        private PendingSpans(ConcurrentHashMap<AbstractWeakConcurrentMap.WeakKey<ReadableSpan>, CallerStackTrace> map, BiConsumer<String, Throwable> reporter) {
            super(false, false, map);
            this.map = map;
            this.reporter = reporter;
        }

        public void run() {
            try {
                while (!Thread.interrupted()) {
                    Reference gcdReference = this.remove();
                    CallerStackTrace caller = this.map.remove(gcdReference);
                    if (caller == null || caller.ended) continue;
                    this.reporter.accept("Span garbage collected before being ended.", (Throwable)((Object)LeakDetectingSpanProcessor.callerError(caller)));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

