/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.jmx.kafkajmx.kafkaprocessor;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.hertzbeat.collector.collect.jmx.MbeanProcessor;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.JmxProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;

public class KafkaCommonProcessor
implements MbeanProcessor {
    Boolean completeFlag = false;

    @Override
    public void preProcess(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        JmxProtocol jmx = metrics.getJmx();
        if (metrics.getJmx().getObjectName() != null && metrics.getJmx().getObjectName().contains("GroupMetadataManager")) {
            jmx.setObjectName("kafka.*:type=GroupMetadataManager,name=*");
        }
    }

    @Override
    public void process(MBeanServerConnection serverConnection, ObjectInstance objectInstance, Set<ObjectInstance> objectInstanceSet, ObjectName objectName, Map<String, String> attributeValueMap, CollectRep.ValueRow.Builder valueRowBuilder) {
        for (ObjectInstance instance : objectInstanceSet) {
            ObjectName currentObjectName = instance.getObjectName();
            try {
                Attribute attribute;
                AttributeList attributes = serverConnection.getAttributes(currentObjectName, new String[]{"Value"});
                Object value = null;
                if (attributes != null && !attributes.isEmpty() && (attribute = (Attribute)attributes.get(0)) != null) {
                    value = attribute.getValue();
                }
                String key = currentObjectName.getKeyProperty("name");
                attributeValueMap.put("Value->" + key, String.valueOf(value));
            }
            catch (IOException | InstanceNotFoundException | ReflectionException e) {
                throw new RuntimeException(e);
            }
        }
        this.completeFlag = true;
    }

    @Override
    public Boolean isCollectionComplete() {
        return this.completeFlag;
    }
}

