/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.List;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6ExtOptionsPacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.util.ByteArrays;

public final class IpV6ExtDestinationOptionsPacket
extends IpV6ExtOptionsPacket {
    private static final long serialVersionUID = -3293888276359687328L;
    private final IpV6ExtDestinationOptionsHeader header;

    public static IpV6ExtDestinationOptionsPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        IpV6ExtDestinationOptionsHeader optHeader = new IpV6ExtDestinationOptionsHeader(rawData, offset, length);
        int payloadLength = length - optHeader.length();
        if (payloadLength > 0) {
            return new IpV6ExtDestinationOptionsPacket(rawData, offset + optHeader.length(), payloadLength, optHeader);
        }
        return new IpV6ExtDestinationOptionsPacket(optHeader);
    }

    private IpV6ExtDestinationOptionsPacket(IpV6ExtDestinationOptionsHeader optHeader) {
        this.header = optHeader;
    }

    private IpV6ExtDestinationOptionsPacket(byte[] rawData, int payloadOffset, int payloadLength, IpV6ExtDestinationOptionsHeader optHeader) {
        super(rawData, payloadOffset, payloadLength, optHeader.getNextHeader());
        this.header = optHeader;
    }

    private IpV6ExtDestinationOptionsPacket(Builder builder) {
        super(builder);
        this.header = new IpV6ExtDestinationOptionsHeader(builder);
    }

    @Override
    public IpV6ExtDestinationOptionsHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IpV6ExtDestinationOptionsHeader
    extends IpV6ExtOptionsPacket.IpV6ExtOptionsHeader {
        private static final long serialVersionUID = 4686702407537705400L;

        private IpV6ExtDestinationOptionsHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            super(rawData, offset, length);
        }

        private IpV6ExtDestinationOptionsHeader(Builder builder) {
            super(builder);
        }

        @Override
        protected String getHeaderName() {
            return "IPv6 Destination Options Header";
        }
    }

    public static final class Builder
    extends IpV6ExtOptionsPacket.Builder {
        public Builder() {
        }

        private Builder(IpV6ExtDestinationOptionsPacket packet) {
            super(packet);
        }

        @Override
        public Builder nextHeader(IpNumber nextHeader) {
            super.nextHeader(nextHeader);
            return this;
        }

        @Override
        public Builder hdrExtLen(byte hdrExtLen) {
            super.hdrExtLen(hdrExtLen);
            return this;
        }

        @Override
        public Builder options(List<IpV6ExtOptionsPacket.IpV6Option> options) {
            super.options(options);
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            super.payloadBuilder(payloadBuilder);
            return this;
        }

        @Override
        public IpV6ExtDestinationOptionsPacket build() {
            return new IpV6ExtDestinationOptionsPacket(this);
        }
    }
}

