/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.common.entity.alerter.JsonMapAttributeConverter;
import org.apache.hertzbeat.common.entity.manager.JsonOptionListAttributeConverter;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_param_define")
@Schema(description="Parameter structure definition entity")
@EntityListeners(value={AuditingEntityListener.class})
public class ParamDefine {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="Parameter structure ID", example="87584674384", accessMode=Schema.AccessMode.READ_ONLY)
    private Long id;
    @Schema(title="Type of monitoring", example="TanCloud", accessMode=Schema.AccessMode.READ_WRITE)
    private String app;
    @Schema(description="The parameter field displays the internationalized name", example="{zh-CN: '\u7aef\u53e3'}", accessMode=Schema.AccessMode.READ_WRITE)
    @Convert(converter=JsonMapAttributeConverter.class)
    @Column(length=2048)
    private Map<String, String> name;
    @Schema(title="Parameter field identifier", example="port", accessMode=Schema.AccessMode.READ_WRITE)
    private String field;
    @Schema(title="Field type, style (mostly map the input tag type attribute)", example="number", accessMode=Schema.AccessMode.READ_WRITE)
    private String type;
    @Schema(title="Is it mandatory true-required false-optional", example="true", accessMode=Schema.AccessMode.READ_WRITE)
    private boolean required = false;
    @Schema(title="Parameter default values", example="12", accessMode=Schema.AccessMode.READ_WRITE)
    private String defaultValue;
    @Schema(title="Parameter input field prompt information", example="enter your password", accessMode=Schema.AccessMode.READ_WRITE)
    private String placeholder;
    @Schema(title="When type is number, the range is represented by the range interval", example="[0,233]", accessMode=Schema.AccessMode.READ_WRITE)
    @Column(name="param_range")
    private String range;
    @Schema(title="When type is text, use limit to indicate the limit size of the string. The maximum is 255", example="30", accessMode=Schema.AccessMode.READ_WRITE)
    @Column(name="param_limit")
    private Short limit;
    @Schema(description="When the type is radio radio box, checkbox checkbox, options represents a list of optional values", example="{key1,value1}", accessMode=Schema.AccessMode.READ_WRITE)
    @Column(name="param_options", length=2048)
    @Convert(converter=JsonOptionListAttributeConverter.class)
    private List<Option> options;
    @Schema(title="Valid when type is key-value, indicating the alias description of the key", example="Name", accessMode=Schema.AccessMode.READ_WRITE)
    private String keyAlias;
    @Schema(title="Valid when type is key-value, indicating the alias description of value type", example="Value", accessMode=Schema.AccessMode.READ_WRITE)
    private String valueAlias;
    @Schema(title="Is it an advanced hidden parameter true-yes false-no", example="true", accessMode=Schema.AccessMode.READ_WRITE)
    private boolean hide = false;
    @Schema(title="The creator of this record", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedBy
    private String creator;
    @Schema(title="The modifier of this record", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedBy
    private String modifier;
    @Schema(title="Record create time", example="1612198922000", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record modify time", example="1612198444000", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedDate
    private LocalDateTime gmtUpdate;
    @Schema(title="Depends on which parameters", example="{field:[value1, value2, ...]}", accessMode=Schema.AccessMode.READ_WRITE)
    @Convert(converter=JsonMapAttributeConverter.class)
    private Map<String, List<Object>> depend;

    public static ParamDefineBuilder builder() {
        return new ParamDefineBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getApp() {
        return this.app;
    }

    public Map<String, String> getName() {
        return this.name;
    }

    public String getField() {
        return this.field;
    }

    public String getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public String getRange() {
        return this.range;
    }

    public Short getLimit() {
        return this.limit;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public String getValueAlias() {
        return this.valueAlias;
    }

    public boolean isHide() {
        return this.hide;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public Map<String, List<Object>> getDepend() {
        return this.depend;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setName(Map<String, String> name) {
        this.name = name;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public void setRange(String range) {
        this.range = range;
    }

    public void setLimit(Short limit) {
        this.limit = limit;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public void setValueAlias(String valueAlias) {
        this.valueAlias = valueAlias;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public void setDepend(Map<String, List<Object>> depend) {
        this.depend = depend;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParamDefine)) {
            return false;
        }
        ParamDefine other = (ParamDefine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRequired() != other.isRequired()) {
            return false;
        }
        if (this.isHide() != other.isHide()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Short this$limit = this.getLimit();
        Short other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$app = this.getApp();
        String other$app = other.getApp();
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        Map<String, String> this$name = this.getName();
        Map<String, String> other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        String this$placeholder = this.getPlaceholder();
        String other$placeholder = other.getPlaceholder();
        if (this$placeholder == null ? other$placeholder != null : !this$placeholder.equals(other$placeholder)) {
            return false;
        }
        String this$range = this.getRange();
        String other$range = other.getRange();
        if (this$range == null ? other$range != null : !this$range.equals(other$range)) {
            return false;
        }
        List<Option> this$options = this.getOptions();
        List<Option> other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        String this$keyAlias = this.getKeyAlias();
        String other$keyAlias = other.getKeyAlias();
        if (this$keyAlias == null ? other$keyAlias != null : !this$keyAlias.equals(other$keyAlias)) {
            return false;
        }
        String this$valueAlias = this.getValueAlias();
        String other$valueAlias = other.getValueAlias();
        if (this$valueAlias == null ? other$valueAlias != null : !this$valueAlias.equals(other$valueAlias)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        if (this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate)) {
            return false;
        }
        Map<String, List<Object>> this$depend = this.getDepend();
        Map<String, List<Object>> other$depend = other.getDepend();
        return !(this$depend == null ? other$depend != null : !((Object)this$depend).equals(other$depend));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParamDefine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRequired() ? 79 : 97);
        result = result * 59 + (this.isHide() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Short $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        Map<String, String> $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        String $placeholder = this.getPlaceholder();
        result = result * 59 + ($placeholder == null ? 43 : $placeholder.hashCode());
        String $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : $range.hashCode());
        List<Option> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        String $keyAlias = this.getKeyAlias();
        result = result * 59 + ($keyAlias == null ? 43 : $keyAlias.hashCode());
        String $valueAlias = this.getValueAlias();
        result = result * 59 + ($valueAlias == null ? 43 : $valueAlias.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        Map<String, List<Object>> $depend = this.getDepend();
        result = result * 59 + ($depend == null ? 43 : ((Object)$depend).hashCode());
        return result;
    }

    public String toString() {
        return "ParamDefine(id=" + this.getId() + ", app=" + this.getApp() + ", name=" + this.getName() + ", field=" + this.getField() + ", type=" + this.getType() + ", required=" + this.isRequired() + ", defaultValue=" + this.getDefaultValue() + ", placeholder=" + this.getPlaceholder() + ", range=" + this.getRange() + ", limit=" + this.getLimit() + ", options=" + this.getOptions() + ", keyAlias=" + this.getKeyAlias() + ", valueAlias=" + this.getValueAlias() + ", hide=" + this.isHide() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ", depend=" + this.getDepend() + ")";
    }

    public ParamDefine(Long id, String app, Map<String, String> name, String field, String type, boolean required, String defaultValue, String placeholder, String range, Short limit, List<Option> options, String keyAlias, String valueAlias, boolean hide, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate, Map<String, List<Object>> depend) {
        this.id = id;
        this.app = app;
        this.name = name;
        this.field = field;
        this.type = type;
        this.required = required;
        this.defaultValue = defaultValue;
        this.placeholder = placeholder;
        this.range = range;
        this.limit = limit;
        this.options = options;
        this.keyAlias = keyAlias;
        this.valueAlias = valueAlias;
        this.hide = hide;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
        this.depend = depend;
    }

    public ParamDefine() {
    }

    public static class ParamDefineBuilder {
        private Long id;
        private String app;
        private Map<String, String> name;
        private String field;
        private String type;
        private boolean required;
        private String defaultValue;
        private String placeholder;
        private String range;
        private Short limit;
        private List<Option> options;
        private String keyAlias;
        private String valueAlias;
        private boolean hide;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;
        private Map<String, List<Object>> depend;

        ParamDefineBuilder() {
        }

        public ParamDefineBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public ParamDefineBuilder app(String app) {
            this.app = app;
            return this;
        }

        public ParamDefineBuilder name(Map<String, String> name) {
            this.name = name;
            return this;
        }

        public ParamDefineBuilder field(String field) {
            this.field = field;
            return this;
        }

        public ParamDefineBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ParamDefineBuilder required(boolean required) {
            this.required = required;
            return this;
        }

        public ParamDefineBuilder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public ParamDefineBuilder placeholder(String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public ParamDefineBuilder range(String range) {
            this.range = range;
            return this;
        }

        public ParamDefineBuilder limit(Short limit) {
            this.limit = limit;
            return this;
        }

        public ParamDefineBuilder options(List<Option> options) {
            this.options = options;
            return this;
        }

        public ParamDefineBuilder keyAlias(String keyAlias) {
            this.keyAlias = keyAlias;
            return this;
        }

        public ParamDefineBuilder valueAlias(String valueAlias) {
            this.valueAlias = valueAlias;
            return this;
        }

        public ParamDefineBuilder hide(boolean hide) {
            this.hide = hide;
            return this;
        }

        public ParamDefineBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public ParamDefineBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public ParamDefineBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public ParamDefineBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public ParamDefineBuilder depend(Map<String, List<Object>> depend) {
            this.depend = depend;
            return this;
        }

        public ParamDefine build() {
            return new ParamDefine(this.id, this.app, this.name, this.field, this.type, this.required, this.defaultValue, this.placeholder, this.range, this.limit, this.options, this.keyAlias, this.valueAlias, this.hide, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate, this.depend);
        }

        public String toString() {
            return "ParamDefine.ParamDefineBuilder(id=" + this.id + ", app=" + this.app + ", name=" + this.name + ", field=" + this.field + ", type=" + this.type + ", required=" + this.required + ", defaultValue=" + this.defaultValue + ", placeholder=" + this.placeholder + ", range=" + this.range + ", limit=" + this.limit + ", options=" + this.options + ", keyAlias=" + this.keyAlias + ", valueAlias=" + this.valueAlias + ", hide=" + this.hide + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ", depend=" + this.depend + ")";
        }
    }

    public static final class Option {
        private String label;
        private String value;

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Option)) {
                return false;
            }
            Option other = (Option)o;
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "ParamDefine.Option(label=" + this.getLabel() + ", value=" + this.getValue() + ")";
        }

        public Option(String label, String value) {
            this.label = label;
            this.value = value;
        }

        public Option() {
        }
    }
}

