/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.ScoredValue;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceStrings;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ScoredValueStreamingChannel;
import java.nio.ByteBuffer;

public class ScoredValueStreamingOutput<K, V>
extends CommandOutput<K, V, Long> {
    private V value;
    private boolean hasValue;
    private final ScoredValueStreamingChannel<V> channel;

    public ScoredValueStreamingOutput(RedisCodec<K, V> codec, ScoredValueStreamingChannel<V> channel) {
        super(codec, 0L);
        this.channel = channel;
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (!this.hasValue) {
            this.value = this.codec.decodeValue(bytes);
            this.hasValue = true;
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeAscii(bytes));
        this.set(score);
    }

    @Override
    public void set(double number) {
        this.channel.onValue(ScoredValue.just(number, this.value));
        this.output = (Long)this.output + 1L;
        this.value = null;
        this.hasValue = false;
    }
}

