/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp.gcs;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import java.net.URI;
import org.apache.iceberg.gcp.GCPProperties;
import org.apache.iceberg.metrics.MetricsContext;

abstract class BaseGCSFile {
    private final Storage storage;
    private final GCPProperties gcpProperties;
    private final BlobId blobId;
    private Blob metadata;
    private final MetricsContext metrics;

    BaseGCSFile(Storage storage, BlobId blobId, GCPProperties gcpProperties, MetricsContext metrics) {
        this.storage = storage;
        this.blobId = blobId;
        this.gcpProperties = gcpProperties;
        this.metrics = metrics;
    }

    public String location() {
        return this.blobId.toGsUtilUri();
    }

    Storage storage() {
        return this.storage;
    }

    URI uri() {
        return URI.create(this.blobId.toGsUtilUri());
    }

    BlobId blobId() {
        return this.blobId;
    }

    protected GCPProperties gcpProperties() {
        return this.gcpProperties;
    }

    protected MetricsContext metrics() {
        return this.metrics;
    }

    public boolean exists() {
        return this.getBlob() != null;
    }

    protected Blob getBlob() {
        if (this.metadata == null) {
            this.metadata = this.storage.get(this.blobId);
        }
        return this.metadata;
    }

    public String toString() {
        return this.blobId.toString();
    }
}

