/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.exceptions.ConnectionFailedException;
import org.apache.gravitino.exceptions.ForbiddenException;
import org.apache.gravitino.exceptions.RESTException;

public class ErrorResponse
extends BaseResponse {
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="message")
    private String message;
    @Nullable
    @JsonProperty(value="stack")
    private List<String> stack;

    private ErrorResponse(int code, String type, String message, List<String> stack) {
        super(code);
        this.type = type;
        this.message = message;
        this.stack = stack;
    }

    private ErrorResponse() {
        this.type = null;
        this.message = null;
        this.stack = null;
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument(this.type != null && !this.type.isEmpty(), "type cannot be null or empty");
        Preconditions.checkArgument(this.message != null && !this.message.isEmpty(), "message cannot be null or empty");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ErrorResponse(").append("code=").append(super.getCode()).append(", type=").append(this.type).append(", message=").append(this.message).append(")");
        if (this.stack != null && !this.stack.isEmpty()) {
            for (String s2 : this.stack) {
                sb.append("\n\t").append(s2);
            }
        }
        return sb.toString();
    }

    public static ErrorResponse restError(String message) {
        return new ErrorResponse(1000, RESTException.class.getSimpleName(), message, null);
    }

    public static ErrorResponse illegalArguments(String message) {
        return ErrorResponse.illegalArguments(message, null);
    }

    public static ErrorResponse illegalArguments(String message, Throwable throwable) {
        return ErrorResponse.illegalArguments(IllegalArgumentException.class.getSimpleName(), message, throwable);
    }

    public static ErrorResponse illegalArguments(String type, String message, Throwable throwable) {
        return new ErrorResponse(1001, type, message, ErrorResponse.getStackTrace(throwable));
    }

    public static ErrorResponse connectionFailed(String message) {
        return ErrorResponse.connectionFailed(message, null);
    }

    public static ErrorResponse connectionFailed(String message, Throwable throwable) {
        return new ErrorResponse(1007, ConnectionFailedException.class.getSimpleName(), message, ErrorResponse.getStackTrace(throwable));
    }

    public static ErrorResponse notFound(String type, String message) {
        return ErrorResponse.notFound(type, message, null);
    }

    public static ErrorResponse notFound(String type, String message, Throwable throwable) {
        return new ErrorResponse(1003, type, message, ErrorResponse.getStackTrace(throwable));
    }

    public static ErrorResponse internalError(String message) {
        return ErrorResponse.internalError(message, null);
    }

    public static ErrorResponse internalError(String message, Throwable throwable) {
        return new ErrorResponse(1002, RuntimeException.class.getSimpleName(), message, ErrorResponse.getStackTrace(throwable));
    }

    public static ErrorResponse alreadyExists(String type, String message) {
        return ErrorResponse.alreadyExists(type, message, null);
    }

    public static ErrorResponse alreadyExists(String type, String message, Throwable throwable) {
        return new ErrorResponse(1004, type, message, ErrorResponse.getStackTrace(throwable));
    }

    public static ErrorResponse notInUse(String type, String message, Throwable throwable) {
        return new ErrorResponse(1009, type, message, ErrorResponse.getStackTrace(throwable));
    }

    public static ErrorResponse inUse(String type, String message, Throwable throwable) {
        return new ErrorResponse(1010, type, message, ErrorResponse.getStackTrace(throwable));
    }

    public static ErrorResponse nonEmpty(String type, String message) {
        return ErrorResponse.nonEmpty(type, message, null);
    }

    public static ErrorResponse nonEmpty(String type, String message, Throwable throwable) {
        return new ErrorResponse(1005, type, message, ErrorResponse.getStackTrace(throwable));
    }

    public static ErrorResponse unknownError(String message) {
        return new ErrorResponse(1100, RuntimeException.class.getSimpleName(), message, null);
    }

    public static ErrorResponse oauthError(int code, String type, String message) {
        return new ErrorResponse(code, type, message, null);
    }

    public static ErrorResponse unsupportedOperation(String message) {
        return ErrorResponse.unsupportedOperation(message, null);
    }

    public static ErrorResponse unsupportedOperation(String message, Throwable throwable) {
        return new ErrorResponse(1006, UnsupportedOperationException.class.getSimpleName(), message, ErrorResponse.getStackTrace(throwable));
    }

    public static ErrorResponse forbidden(String message, Throwable throwable) {
        return new ErrorResponse(1008, ForbiddenException.class.getSimpleName(), message, ErrorResponse.getStackTrace(throwable));
    }

    private static List<String> getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            throwable.printStackTrace(pw);
        }
        return Arrays.asList(sw.toString().split("\n"));
    }

    public String getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    @Nullable
    public List<String> getStack() {
        return this.stack;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorResponse)) {
            return false;
        }
        ErrorResponse other = (ErrorResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        List<String> this$stack = this.getStack();
        List<String> other$stack = other.getStack();
        return !(this$stack == null ? other$stack != null : !((Object)this$stack).equals(other$stack));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ErrorResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        List<String> $stack = this.getStack();
        result = result * 59 + ($stack == null ? 43 : ((Object)$stack).hashCode());
        return result;
    }
}

