/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.rel.partitioning;

import java.util.Arrays;
import org.apache.gravitino.dto.rel.ColumnDTO;
import org.apache.gravitino.dto.rel.PartitionUtils;
import org.apache.gravitino.dto.rel.partitioning.Partitioning;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.transforms.Transforms;

public final class BucketPartitioningDTO
implements Partitioning {
    private final int numBuckets;
    private final String[][] fieldNames;

    public static BucketPartitioningDTO of(int numBuckets, String[] ... fieldNames) {
        return new BucketPartitioningDTO(numBuckets, fieldNames);
    }

    private BucketPartitioningDTO(int numBuckets, String[][] fieldNames) {
        this.numBuckets = numBuckets;
        this.fieldNames = fieldNames;
    }

    public int numBuckets() {
        return this.numBuckets;
    }

    public String[][] fieldNames() {
        return this.fieldNames;
    }

    @Override
    public Partitioning.Strategy strategy() {
        return Partitioning.Strategy.BUCKET;
    }

    @Override
    public void validate(ColumnDTO[] columns) throws IllegalArgumentException {
        Arrays.stream(this.fieldNames).forEach(fieldName -> PartitionUtils.validateFieldExistence(columns, fieldName));
    }

    @Override
    public String name() {
        return this.strategy().name().toLowerCase();
    }

    @Override
    public Expression[] arguments() {
        return Transforms.bucket(this.numBuckets, this.fieldNames).arguments();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BucketPartitioningDTO)) {
            return false;
        }
        BucketPartitioningDTO other = (BucketPartitioningDTO)o;
        if (this.numBuckets != other.numBuckets) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.fieldNames, (Object[])other.fieldNames);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.numBuckets;
        result = result * 59 + Arrays.deepHashCode((Object[])this.fieldNames);
        return result;
    }
}

