/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.List;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchUserException;

public class RoleDetails
extends Command {
    protected String metalake;
    protected String role;

    public RoleDetails(CommandContext context, String metalake, String role) {
        super(context);
        this.metalake = metalake;
        this.role = role;
    }

    @Override
    public void handle() {
        List<SecurableObject> objects = null;
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            objects = client.getRole(this.role).securableObjects();
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchUserException err) {
            this.exitWithError("Unknown group.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        for (SecurableObject object : objects) {
            this.printInformation(object.name() + "," + (Object)((Object)object.type()) + ",");
            for (Privilege privilege : object.privileges()) {
                this.printInformation(privilege.simpleString() + " ");
            }
        }
        this.printInformation("");
    }
}

